'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//分享日志
var ForumShareLogSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	user: { //分享者
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumUser'
	},
	thread: { //分享内容
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumThread'
	},
	destination: { //分享的目标，微信好友，微信朋友圈，QQ空间，微博等等
		type: String,
		require: true,
		index: true
	},
	ip: { //IP地址
		type: String,
		require: true
	},
	created: { //分享时间
		type: Date,
		require: true,
		default: Date.now
	}
}, {
	'collection': 'pisns_forum_share_log'
});

module.exports = mongoose.model('ForumShareLog', ForumShareLogSchema);