'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//话题，文章
var ForumThreadSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	forum: {
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'Forum'
	},
	title: { //话题标题
		type: String,
		require: true
	},
	content: { //话题内容
		type: String,
		require: true
	},
	icon: { //话题图标
		type: String,
		require: true
	},
	order_idx: { //论坛排序
		type: Number,
		require: true,
		default: 0
	},
	top: { //话题是否置顶0否，1是
		type: Number,
		require: true,
		default: 0
	},
	tag: { //话题归属标签
		type: Array
	},
	comments: { //评论内容列表
		type: Array
	},
	share: { //自定义分享
		type: Schema.Types.ObjectId,
		ref: 'ForumShare'
	},
	pv_count: { //话题的访问量
		type: Number,
		require: true,
		default: 0
	},
	comment_count: { //评论数量
		type: Number,
		require: true,
		default: 0
	},
	share_count: { //分享数量
		type: Number,
		require: true,
		default: 0
	},
	praise_count: { //点赞数量
		type: Number,
		require: true,
		default: 0
	},
	status: { //论坛状态，1启用，0禁用
		type: Number,
		require: true,
		default: 1
	}

}, {
	'collection': 'pisns_forum_thread'
});


module.exports = mongoose.model('ForumThread', ForumThreadSchema);