'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//论坛用户
var ForumUserSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	uid: { //用户ID，这里直接存放用户的openId
		type: String,
		index: true,
		require: true
	},
	nickName: { //用户昵称，这里直接存放用户的nickname
		type: String,
		require: true
	},
	displayName: { //自定义显示名称
		type: String
	},
	icon: { //用户头像
		type: String,
		require: true
	},
	displayIcon: { //自定义显示头像
		type: String
	},
	classLevel: { //等级,暂时不用
		type: Number,
		require: true,
		default: 0
	},
	role: { //用户角色
		type: Schema.Types.ObjectId,
		require: true
	}
	status: { //用户状态1，正常，2黑名单
		type: Number,
		require: true,
		default: 1
	}
}, {
	'collection': 'pisns_forum_user'
});


module.exports = mongoose.model('ForumUser', ForumUserSchema);