'use strict';
var path = require('path'),
  rootPath = path.normalize(__dirname + '/..'),
  env = process.env.NODE_ENV || 'development';

var config = {
  development: {
    root: rootPath,
    app: {
      name: 'pisns-forum-api'
    },
    port: 3011,
    mongodb: {
      uri:'114.215.206.32:27018'
      username: '',
      password: '',
      dbname: 'piscrm',
      poolSize: 5
    }
  },

  test: {
    root: rootPath,
    app: {
      name: 'pisns-forum-api'
    },
    port: 3011,
    mongo: {
      uri:'114.215.206.32:27018'
      username: '',
      password: '',
      dbname: 'sandbox',
      poolSize: 5
    }

  },

  production: {
    root: rootPath,
    app: {
      name: 'pisns-forum-api'
    },
    port: 3011,
    mongo: {
      uri:'10.165.15.168:27017'
      username: 'future',
      password: 'future123456',
      dbname: 'piscrm',
      poolSize: 50
    }
  }
};

module.exports = config[env];