'use strict';
var express = require('express'),
    router = express.Router(),
    then = require('thenjs'),
    returnCode = require('../../utils/returnCode'),
    async = require('async'),
    _ = require('lodash');

var mongoose = require('mongoose');
var forumHonorTitleService = require('../../service/forumHonorTitleService');
var forumUserService = require('../../service/forumUserService');
var forumUserHonorTimeLineService = require('../../service/forumUserHonorTimeLineService');
var util = require('../../utils/util');

module.exports = function(app) {
    app.use('/v1/forum', router);
};

//查询单个头衔信息人员信息
router.get('/honorTitle/:hid/list', function(req, res, next) {
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 999;
    var ent_code = req.session.user.ent_code;
    var honorTitleId = req.params.hid;

    var conditions = {
        ent_code: ent_code,
        honor: honorTitleId
    };

    var fields = "nickName icon uid";

    forumUserHonorTimeLineService.getAll(pageNo, pageSize, conditions, fields,'_id', function(err, results) {
        if (err) {
            console.error(err);
            cont(err, null);
        } else {
            var users = [];
            _.forEach(results.datas, function(one, i) {
                users.push(one.user);
            });
            results.datas = users;
            util.loadLevelByUser(ent_code, results.datas, function() {
                res.json(_.assign(results, returnCode.SUCCESS));
            });
        }
    });
});


//查询所有头衔信息、前4头衔人员信息
router.get('/honorTitle/list', function(req, res, next) {
    var pageNo = req.query.pageNo || 1,
        pageSize = req.query.pageSize || 4,
        ent_code = req.session.user.ent_code;

    var honorTitle_condition = {
        ent_code: ent_code,
        status: 1
    }
    var fields = "nickName icon";

    async.waterfall([
        function(callback) {
            //查询所有头衔
            forumHonorTitleService.find(honorTitle_condition, function(err, list) {
                callback(err, list);
            });
        },
        function(list, callback) { //获取用户
            var asyncTasks = [];
            _.forEach(list, function(one, i) {
                asyncTasks.push(function(cont) {
                    var user_conditions = {
                        ent_code: ent_code,
                        honor: one._id
                    };
                    forumUserHonorTimeLineService.getAll(pageNo, pageSize, user_conditions,fields,'-_id', function(err, results) {
                        if (err) {
                            console.error(err);
                            cont(err, null);
                        } else {
                            if (list[i].toObject) {
                                list[i] = list[i].toObject();
                            }
                            var users = [];
                            _.forEach(results.datas, function(one, i) {
                                users.push(one.user);
                            });
                            list[i].totalUser = results.total;
                            list[i].users = users;
                            cont(null, one);
                        }
                    });
                });
            });
            then.parallel(asyncTasks).then(function(cont, datas) {
                callback(null, list);
            }).fail(function(err, cont) {
                callback(err, null);
            });
        }
    ], function(err, result) {
        if (err) {
            console.error(err);
            res.json(returnCode.BUSY);
        } else {
            res.json(_.assign(result, returnCode.SUCCESS));
        }
    });
});