'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	moment = require('moment'),
	_ = require('lodash'),
	then = require('thenjs');

var forumUserService=require('../../service/forumUserService');
var forumMessageService=require('../../service/forumMessageService');

var async=require('async');

var user=require('../../utils/user');

module.exports = function(app) {
	app.use('/v1/forum', router);
};

//分页用户查询消息
router.get('/message/searchMesage', function(req, res, next) {
    //参数
    var pageNo = req.query.pageNo || 1,
        pageSize = req.query.pageSize || 10,
        from = user.getMobileUser(req),
        ent_code = req.session.user.ent_code;

    async.waterfall([ 
		function(callback) { //获取消息列表
			var q = {
		        ent_code: ent_code,
		        _id:from
		    } 
		    var status = 2; //过滤的状态,2 用户自己屏蔽的消息
            forumMessageService.getMessages(q, status, pageNo, pageSize, function(err, total, messages){
            	if(err){
            		callback(err,null,null);
            	}else{
            		callback(null,total,messages);
            	}
            });
        },
        function(total, messages, callback) { 
        	var getMessage_tasks = [];
	        _.forEach(messages, function(message, key) {
	            getMessage_tasks.push(function(cont) {
	                forumMessageService.getByIdWithSelect(message.msg,function(err,doc){
						if (err) {
		                    cont(err, null);
		                } else {
		                	if (messages[key].toObject) {
                                messages[key] = messages[key].toObject();
                            }
		                	messages[key].msg = doc;
		                    cont(null, null);
		                }
					});
	            });
	        });
            then.parallel(getMessage_tasks).then(function(cont, datas) {
                callback(null, total, messages);
            }).fail(function(err, cont) {
                callback(err, null, null);
            });
        }
    ], function(err, total, result) {
        if (err) {
            console.error(err);
            res.json(returnCode.BUSY);
        } else {
        	var obj = {};
            obj.total = total;
            obj.pageNo = pageNo;
            obj.pageSize = pageSize;
            obj.items = result;
            res.json(_.assign(obj, returnCode.SUCCESS));
        }
    });
});


//读取单条消息
router.get('/message/:mid/get', function(req, res, next) {
    //消息参数
    var mid = req.params.mid || null;
    var userID = user.getMobileUser(req);
    if(mid){
    	var condition = {
	        _id: mid
	    }
	    async.parallel([
            function(cb) {
                //获取消息                                        
                forumMessageService.getByIdWithSelect(condition, function(err, result) {
					if (err) {
                        console.error(err);
                        cb(err, null);
                    } else {
                        cb(null, result);
                    }
			    });
            },
            function(cb) {
                //更新用户的消息状态为未读
                forumMessageService.updateUserMessageStatus({_id:userID}, mid, 1, function(err, result) {
                    if (err) {
                        console.error(err);
                        cb(err, null);
                    } else {
                        cb(null, result);
                    }
                });
            }
        ], function(err, results) {
            if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				res.json(_.assign(results[0], returnCode.SUCCESS));
			}
        });
    }else{
    	res.json(returnCode.WRONG_PARAM);
    }
});    

//读取用户未读消息
router.get('/message/unReadMsg', function(req, res, next) {
    //消息参数
    var userID = user.getMobileUser(req);
    if(userID){
    	var condition = {
	        _id: userID
	    }
	    forumMessageService.countUnReadMessage(condition, function(err, result) {
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				var rs = {
					data:result
				}
				res.json(_.assign(rs, returnCode.SUCCESS));
			}
	    }); 
    }else{
    	res.json(returnCode.WRONG_PARAM);
    }
});

//用户把消息改成删除(修改状态)
router.post('/message/:mid/unShowMsg', function(req, res, next) {
    //消息参数
    var mid = req.params.mid || null;
    var userID = user.getMobileUser(req);
    if(mid && userID){
	    //更新用户的消息状态为未读
	    forumMessageService.updateUserMessageStatus({_id:userID}, mid, 2, function(err, result) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                res.json(returnCode.SUCCESS);
            }
        });
    }else{
    	res.json(returnCode.WRONG_PARAM);
    }
});