'use strict';
var express = require('express'),
    router = express.Router(),
    _ = require('lodash'),
    then = require('thenjs'),
    request=require('request'),
    mongoose = require('mongoose');

var forumThreadService = require('../../service/forumThreadService'),
    returnCode = require('../../utils/returnCode'),
    forumShareConfigService = require('../../service/forumShareConfigService'),
    forumShareService = require('../../service/forumShareService'),
    config = require('../../../config/config'),
    httpService=require('../../service/httpService'),
    forumInfoService = require('../../service/forumInfoService'),
    // forumLimitActionRefService = require('../../service/forumLimitActionRefService'),
    forumLimitOperationService = require('../../service/forumLimitOperationService');

var Notice = mongoose.model('ForumNotice');
var redis=global.redis;

module.exports = function(app) {
    app.use('/v1/forum', router);
};


function write(res, title, desc, link, imgUrl, mid, ent_code) {
    res.writeHead(200, {
        'Content-Type': 'text/javascript',
        'Cache-Control': 'no-cache',
        'Pragma': 'no-cache'
    });
    res.write('$(function(){');
    var success_singlemessage = '$.ajax({'+
                                 'type:\'GET\','+
                                 'url: \'/v1/forum/'+ent_code+'/share/singlemessage\''+
                            '});';
    var success_timeline = '$.ajax({'+
                                 'type:\'GET\','+
                                 'url: \'/v1/forum/'+ent_code+'/share/timeline\''+
                            '});';
    var string = 'wx.onMenuShareTimeline({' + '\"title\": \"' + title + '\",' + '\"link\":\"' + link + '\",' + '\"imgUrl\": \"' + imgUrl + '\", ' + 'success: function(){'+success_timeline+'},' + 'cancel: function () {}' + '    });' + 
                ' wx.onMenuShareAppMessage({' + '\"title\": \"' + title + '\", ' + '\"desc\": \"' + desc + '\", ' + '\"link\":\"' + link + '\", ' + '\"imgUrl\": \"' + imgUrl + '\", ' + '\"type\":\'\' ,' + '\"dataUrl\": \'\', ' + 'success: function(){'+success_singlemessage+'},' + 'cancel: function () { ' + '}' + '    });'

    res.write('wx.ready(function(){' + string + '});');
    res.write('wx.error(function(res){console.log(res);});');
    res.write('});');
    res.end();
}

function getWX(res, title, desc, link, imgUrl, mid,ent_code, id,type,forumThread) {
    //['{板块名称}','{文章标题}','{话题名称}','{照片墙标题}'];
    //share_type:是否使用默认设置:1使用默认分享设置  2.使用自己的分享设置
    link = config.service + link + "&mid=" + mid;
  
    if (type==="Info") {
        forumInfoService.getInfoById(id, function(err, forumInfo) {
            if (err || forumInfo < 1) {
                console.error("板块不存在或者发生未知错误");
                res.json({
                    message: '板块不存在或者发生未知错误',
                    result: false,
                    code: '10002',
                    error:err
                });
            }else{
                title = title?title.replace(/{板块名称}/g, forumInfo.name):'';
                desc = desc?desc.replace(/{板块名称}/g, forumInfo.description):'';
            }
        });  
    } else if(type === "Thread"){
        title = title?title.replace(/{文章标题}|{话题名称}|{照片墙标题}/g, forumThread.title):'';
        desc = desc?desc.replace(/{文章标题}|{话题名称}|{照片墙标题}/g, forumThread.content):'';
    } 
    if(desc && desc.length > 30){
        desc = desc.substr(0,30);
    }else if(!desc){
        desc = '';
    }
    write(res, title, desc, link, imgUrl, mid,ent_code);
}

//微信分享接口
router.get('/:ent_code/share.js', function(req, res, next) {
    var rs = {},
        type = req.query.type,
        id = req.query.id,
        uId= req.session.mobileForumUser.userId,
        ent_code = req.params.ent_code,
        mid = req.session.openUser.mid,
        link = '/app/forum/' + ent_code + '/index?pageUrl=',
        share_log = {};
    var title = '',desc = '',imgUrl = '';    
    delete req.session.mobileForumUser.share_log;
    //板块微信接口
    if(!type || !id){
        console.error('请求参数错误')
        res.json(_.assign({result:false},returnCode.WRONG_PARAM));
    }else if (type === 'Info') {
        //分享记录对象
        share_log.type = 2;
        share_log.info = id;
		
		forumInfoService.getInfoById(id, function(err, forumInfo) {
            if (err) {
                console.error(err);
                res.json(_.assign({result:false},returnCode.BUSY));
				return;
            }else{
                if(forumInfo.share_type == 1 && forumInfo.share){
                    var shareInfo = forumInfo.share || {};
                    title = shareInfo.title,desc = shareInfo.description,imgUrl = shareInfo.icon;
                }else{
                    //默认分享设置
                    title = forumInfo.name,desc = forumInfo.description,imgUrl = forumInfo.icon;
                }
                link += 'index&infoId='+ id+'&uId='+uId;
                getWX(res, title, desc, link, imgUrl, mid,ent_code, id,type,null);
            }
        });
    }else if (type === 'Thread') {
        share_log.type = 3;
        share_log.thread = id;
        then(function(cont) {
            //获得文章
            forumThreadService.getById(id,cont);
        }).then(function(cont, thread) {
            if(!thread){
                //文章个性化分享设置不存在
                console.error('分享文章不存在');
                res.json(_.assign({result:false},returnCode.DATA_NOTEXITS));
            }else{
                share_log.p_thread = thread.pid;
                share_log.info = thread.info;
                share_log.thread_type = thread.pid?4:thread.type;
                //组装分享路径与判断分享类型
                //判断分享类型 1、文章 2、话题 3、照片墙
                var share_type = '';
                switch(thread.type){
                    case 1:
                        link += 'thread';
                        share_type = 'article';
                        title = thread.title == '发话题'?thread.info.name:thread.title;;
                    break;
                    case 2:
                        if(thread.level === 2){
                            link += 'thread';
                            share_type = 'article';
                            title = thread.info.name;
                        }else{
                            link += 'topicList';
                            share_type = 'topic';
                            title = thread.pid.title;
                        }
                    break;
                    case 3:
                        if(thread.level === 2){
                            link += 'thread';
                            share_type = 'article';
                            title = thread.info.name;
                        }else{
                            link += 'photoList';
                            share_type = 'photo';
                            title = thread.pid.title;
                        }
                    break;
                }
                var baseParamsUrl = '&infoId=' + thread.info + '&ent_code=' + ent_code + '&id=' + thread._id + '&uId='+uId;
                link += baseParamsUrl;
                desc = thread.content?thread.content.replace(/<\/?.+?>/g,"").replace(/&nbsp;/g,""):'';
                imgUrl = thread.from.displayIcon || thread.from.icon || thread.info.icon;
                //获取分享设置
                if (!thread.share || thread.share_type!==2) {
                    //获取默认文章分享
                    getWX(res, title, desc, link, imgUrl, mid,ent_code,thread._id,type,thread);
                } else {
                    //获取个性化文章分享设置
                    forumShareService.getById(thread.share, function(err, forumShare) {
                        if(err || !forumShare){
                            //文章个性化分享设置不存在
                            console.error(err || '文章个性化分享设置不存在');
                            res.json(_.assign({result:false},returnCode.DATA_NOTEXITS));
                        }else{
                            getWX(res, forumShare.title, forumShare.description, link, forumShare.icon, mid,ent_code,thread._id,type,thread);    
                        }
                    });
                }
            }
        }).fail(function(cont, err) {
            console.error(err);
            res.json(_.assign({result:false},returnCode.WRONG_PARAM));
        });
    }
    req.session.mobileForumUser.share_log = share_log;
});

//微信分享朋友圈接口
router.get('/:ent_code/share/timeline', function(req, res, next) {
    var mid = req.session.openUser.mid,
        action = 'share_timeline',
        ent_code = req.session.user.ent_code;

    var userId = req.session.mobileForumUser.userId;

    forumLimitOperationService.checkLimitOperationProhibitionAddIntegral(userId, function(err, flag){
        if(err){
            console.error(err);
            res.json(returnCode.PROHIBITION_OF_SPEECH);
        }else{
            if(flag){
                res.json(returnCode.PROHIBITION_OF_SPEECH);
            }else{
                httpService.createShareLog(req,1);    
                httpService.sendRequest(ent_code,mid,action);
                res.status(200).end();
            }
        }
    });
});

//微信分享单人接口
router.get('/:ent_code/share/singlemessage', function(req, res, next) {
    var mid = req.session.openUser.mid,
        action = 'share_singlemessage',
        ent_code = req.session.user.ent_code;  
    
    var userId = req.session.mobileForumUser.userId;
    forumLimitOperationService.checkLimitOperationProhibitionAddIntegral(userId, function(err, flag){
        if(err){
            console.error(err);
            res.json(returnCode.PROHIBITION_OF_SPEECH);
        }else{
            if(flag){
                res.json(returnCode.PROHIBITION_OF_SPEECH);
            }else{
                httpService.createShareLog(req,2);    
                httpService.sendRequest(ent_code,mid,action);
                res.status(200).end();
            }
        }
    });
});
function getWXV2(res, title, desc, link, imgUrl, mid,ent_code, id,type,forumThread,fullurl) {
    //['{板块名称}','{文章标题}','{话题名称}','{照片墙标题}'];
    //share_type:是否使用默认设置:1使用默认分享设置  2.使用自己的分享设置
    if(fullurl){
        link = link + "&mid=" + mid;
    }else{
        link = config.service + link + "&mid=" + mid;
    }

    if(type==="Info") {
        forumInfoService.getInfoById(id, function(err, forumInfo) {
            if (err || forumInfo < 1) {
                console.error("板块不存在或者发生未知错误");
                res.json({
                    message: '板块不存在或者发生未知错误',
                    result: false,
                    code: '10002',
                    error:err
                });
            }else{
                title = title?title.replace(/{板块名称}/g, forumInfo.name):'';
                desc = desc?desc.replace(/{板块名称}/g, forumInfo.description):'';
            }
        });  
    }else if(type === "Thread"){
        title = title?title.replace(/{文章标题}|{话题名称}|{照片墙标题}/g, forumThread.title):'';
        desc = desc?desc.replace(/{文章标题}|{话题名称}|{照片墙标题}/g, forumThread.content):'';
    } 

    if(desc && desc.length > 30){
        desc = desc.substr(0,30);
    }else if(!desc){
        desc = '';
    }

    var tempTitle = "";
    if(!title){
        tempTitle = desc;
    }else{
        tempTitle = title;
    }

    res.json({
        title:tempTitle,
        desc:desc,
        link:link,
        imgUrl:imgUrl,
        ent_code:ent_code
    });
}
//微信分享接口V2
router.get('/sharev2.js', function(req, res, next) {
    var rs = {},
        type = req.query.type,
        id = req.query.id,
        uId= req.session.mobileForumUser.userId,
        ent_code = req.session.user.ent_code,
        mid = req.session.openUser.mid,
        link = '/app/forum/' + ent_code + '/v2?pageUrl=',
        share_log = {};

    delete req.session.shareLog; //新的分享对象

    var title = '',desc = '',imgUrl = '';

    var key = ent_code + 'forum_share_index_info';
    if(type && type === 'index'){
        var expire = 60 * 60;
        redis.get(key, function(error, share){
            if(share){//有缓存
                try{
                    share = JSON.parse(share);
                    title=share.title;
                    desc=share.desc;
                    link=share.linkUrl;
                    imgUrl=share.imgUrl;
                    if(link.indexOf('?') === -1){
                        link = link + '?uId='+ uId;
                    }else{
                        link = link + '&uId='+ uId;
                    }
                }catch(err){
                    console.log(err);
                }
                getWXV2(res, title, desc, link, imgUrl, mid,ent_code, id,type,null,true);
            }else{
                then.parallel([
                    function(cont){
                        //type为index时的，默认link
                        link = config.service + '/app/forum/' + ent_code + '/mediashequn'
                        request.get({url:config.rest_api+'/v1.0/internal/forum/config/enter/byentcode?entCode='+ent_code,body:{},json:true}, function (e, r, result) {
                            if(result.data){
                                link = result.data;
                            }
                            cont();
                        });
                    },function(cont){
                        request.get({url:config.rest_api+'/v1.0/internal/forum/config/share/byentcode?entCode='+ent_code,body:{},json:true}, function (e, r, result) {
                            if(result.data){
                                try{
                                    var obj = JSON.parse(result.data);
                                    title = obj.shareTitle || '';
                                    desc = obj.shareDescription || '';
                                    imgUrl = obj.sharePictureUrl || '';
                                }catch(err){
                                    console.log(err);
                                }
                            }
                            cont();
                        });
                    }
                ]).then(function(cont, datas) {
                    //放入redis缓存
                    redis.set(key,JSON.stringify({
                        title:title,
                        desc:desc,
                        linkUrl:link,
                        imgUrl:imgUrl
                    }),function(){
                        redis.expire(key, expire);
                    });
                    if(link.indexOf('?') === -1){
                        link = link + '?uId='+ uId;
                    }else{
                        link = link + '&uId='+ uId;
                    }
                    getWXV2(res, title, desc, link, imgUrl, mid,ent_code, id,type,null,true);
                }).fail(function(cont, err) {
                    res.json(_.assign({result:false},returnCode.WRONG_PARAM));
                });
            }
        });
    }else{
        //板块微信接口
        if(!type || !id){
            console.error('请求参数错误')
            res.json(_.assign({result:false},returnCode.WRONG_PARAM));
        }else if(type === 'notice'){
            Notice.findOne({_id:id},function(err,result){
                if (err) {
                    console.error(err);
                    res.json(_.assign({result:false},returnCode.BUSY));
                }
                link = link + 'noticeDetail&infoId=' + (result.plate || '') + '&ent_code=' + ent_code + '&tId=' + result._id +'&uId='+uId;
                title = result.title;
                desc = result.content?result.content.replace(/<\/?.+?>/g,"").replace(/&nbsp;/g,"").replace(/\t/g,"").replace(/\n/g,""):'';
                redis.get(key, function(error, share){
                    if(share){//有缓存
                        try{
                            share = JSON.parse(share);
                            imgUrl=share.imgUrl;
                        }catch(err){
                            console.log(err);
                        }
                        getWXV2(res, title, desc, link, imgUrl, mid,ent_code, id,type,null);
                    }else{
                        request.get({url:config.rest_api+'/v1.0/internal/forum/config/share/byentcode?entCode='+ent_code,body:{},json:true}, function (e, r, result) {
                            if(result.data){
                                try{
                                    var obj = JSON.parse(result.data);
                                    imgUrl = obj.sharePictureUrl || '';
                                }catch(err){
                                    console.log(err);
                                }
                            }
                            getWXV2(res, title, desc, link, imgUrl, mid,ent_code, id,type,null);
                        });
                    }
                });
            });
        }else if (type === 'Info') {
            //分享记录对象
            share_log.type = 2;
            share_log.info = id;
            //替换分享log内容
            req.session.shareLog = share_log;

            forumInfoService.getInfoById(id, function(err, forumInfo) {
                if (err) {
                    console.error(err);
                    res.json(_.assign({result:false},returnCode.BUSY));
                }else{
                    if(forumInfo.share_type && forumInfo.share_type == 1){
                        var shareInfo = forumInfo.share || {};
                        title = shareInfo.title,desc = shareInfo.description,imgUrl = shareInfo.icon;
                    }else{
                        title = forumInfo.name,desc = forumInfo.description,imgUrl = forumInfo.icon;
                    }
                    link = link + 'index&infoId='+ id+'&uId='+uId;
                    getWXV2(res, title, desc, link, imgUrl, mid,ent_code, id,type,null);
                }
            });

        }else if (type === 'Thread') {
            then(function(cont) {
                //获得文章
                forumThreadService.getThreadByIdSimple({_id:id},cont);
            }).then(function(cont, thread) {
                if(!thread){
                    //文章不存在
                    cont('分享文章不存在');
                }else{
                    share_log.type = 3;
                    share_log.thread = id;
                    share_log.p_thread = thread.pid;
                    share_log.info = thread.info._id || thread.info;
                    share_log.thread_type = thread.pid?4:thread.type;
                    //替换分享log内容
                    req.session.shareLog = share_log;


                    //组装分享路径与判断分享类型
                    var baseParamsUrl =  '&infoId=' + thread.info._id + '&ent_code=' + ent_code + '&tId=' + thread._id +'&uId='+uId;
                    var share_type = '';
                    switch(thread.type){
                        case 1://文章
                            link = link + 'detail';
                            share_type = 'article';
                            title = thread.title == '发话题'?"":thread.title;
                            break;
                        case 2://话题
                            if(thread.level === 2){
                                link += 'detail';
                                share_type = 'article';
                                title = thread.pid.title;
                            }else if(thread.level === 1){
                                link += 'topic';
                                share_type = 'topic';
                                title = thread.title;
                            }
                            break;
                        case 3://照片墙
                            if(thread.level === 2){
                                link += 'photoDetail';
                                share_type = 'photo';
                                title = thread.pid.title;
                            }else if(thread.level === 1){
                                link += 'photoWall';
                                share_type = 'photo';
                                title = thread.title;
                            }
                            break;
                    }
                    desc = thread.content?thread.content.replace(/<\/?.+?>/g,"").replace(/&nbsp;/g,"").replace(/\t/g,"").replace(/\n/g,""):'';

                    // 分享图标：帖子带图片则使用第一张图片，否则使用发帖者的头像
                    if(thread.images && thread.images[0]){
                        imgUrl = thread.images[0].urlFileName;
                    }else{
                        imgUrl = thread.from.displayIcon || thread.from.icon || thread.info.icon;
                    }

                    link  += baseParamsUrl;
                    //获取分享设置
                    if (thread.share_type!==2) {
                        //文章默认分享
                        getWXV2(res, title, desc, link, imgUrl, mid,ent_code,thread._id,type,thread);
                    }else if(thread.share){
                        getWXV2(res, thread.share.title, thread.share.description, link, thread.share.icon, mid,ent_code,thread._id,type,thread);
                    } else {
                        getWXV2(res, title, desc, link, imgUrl, mid,ent_code,thread._id,type,thread);
                    }
                }
            }).fail(function(cont, err) {
                console.error(err);
                res.json(_.assign({result:false},returnCode.WRONG_PARAM));
            });
        }
    }
});