'use strict';
var express = require('express'),
    router = express.Router(),
    returnCode = require('../../utils/returnCode'),
    _ = require('lodash');

var mongoose = require('mongoose');
var forumUserService = require('../../service/forumUserService');
var forumThreadService = require('../../service/forumThreadService');
var forumInfoService = require('../../service/forumInfoService');

var async = require('async');

var user = require('../../utils/user');

module.exports = function(app) {
    app.use('/v1/forum', router);
};

//更新用户收藏信息
var updateuser = function(condition, entity, callback){
	forumUserService.updateByIdWithOptions(condition, entity, {upsert: false}, function(err, user_id) {
        if (err) {
            callback(err, null);
        } else {
            callback(null, user_id);
        }
    });
};

//查询用户是否已收藏(板块/文章/用户)
var queryIsFavor = function(userID, field, condition, callback){
	forumUserService.getUserById(userID, function(err, doc) {
        if (err) {
            callback(err, null);
        } else {
        	if(doc){
        		var list = doc[field];
        		if (list.indexOf(condition) > -1) {
				    callback(1); 
				} else {
				    callback(null);
				}
        	}else{
        		callback('查询用户信息错误');
        	}
        }
    });
};

//获取用户信息
router.get('/user/:fid/get', function(req, res, next) {
    var fid = req.params.fid || null;
    var rs = {};
    async.parallel([
        function(cb) {
            forumUserService.getUserById(user.getMobileUser(req), function(err, entity) {
                if (err) {
                    cb(err, null);
                } else {
                    cb(null, entity);
                }
            });
        },
        function(cb) {
            var conditions = {
                ent_code: req.session.user.ent_code,
                from: user.getMobileUser(req),
                status: 1,
                info: fid
            };
            forumThreadService.getAllCountByFid(conditions, function(err, count) {
                if (err) {
                    cb(err, null);
                } else {
                    cb(null, count);
                }
            });
        }
    ], function(err, results) {
        if (err) {
            console.error(err);
            res.json(returnCode.BUSY);
        } else {
            rs.data = results[0] || {};
            rs.myThreadCount = results[1] || 0;
            res.json(_.assign(rs, returnCode.SUCCESS));
        }
    });
});

//更新用户信息
router.post('/user/:uid/update', function(req, res, next) {
    var uid = req.params.uid;
    if (uid) {
        forumUserService.updateUserById(uid, req.body, function(err, result) {
            if (err) {
                res.json(returnCode.BUSY);
            } else {
                res.json(returnCode.SUCCESS);
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//收藏板块
router.post('/user/favorInfo/:infoID', function(req, res, next) {
    var userID = user.getMobileUser(req);
    var ent_code = req.session.user.ent_code;
    var infoID = req.params.infoID;
    if (userID && infoID) {
        async.waterfall([
        	function(callback) {
		        queryIsFavor(userID, 'favor_infos', infoID, callback);
		    },
		    function(callback) {
		    	//更新用户
		    	var user_condition = { _id : userID, ent_code : ent_code};
        		var user_entity = { $push: { "favor_infos": infoID} };
		    	updateuser(user_condition, user_entity, callback);
		    },
		    function(user_id, callback) {
		      	//更新板块
		      	var info_condition = { _id : infoID, ent_code : ent_code};
        		var info_entity = { $push: { "favor_by": user_id} };
		        forumInfoService.updateByIdWithOptions(info_condition, info_entity, {upsert: true}, function(err, result) {
		            if (err) {
		                callback(err, null);
		            } else {
		                callback(null, null);
		            }
		        });
		    }
		], function (err, result) {
		    if (err) {
                if(err == 1){
		    		var rs = {
					  'errorcode': 1,
					  'errormsg': '已收藏'
					}
		    		res.json(rs);
		    	}else{
		    		res.json(returnCode.BUSY);
		    	}
            } else {
                res.json(returnCode.SUCCESS);
            }
		});
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});


//取消收藏板块
router.post('/user/disfavorInfo/:infoID', function(req, res, next) {
    var userID = user.getMobileUser(req);
    var ent_code = req.session.user.ent_code;
    var infoID = req.params.infoID;
    if (userID && infoID) {
        async.waterfall([
		    function(callback) {
		    	//更新用户
		    	var user_condition = { _id : userID, ent_code : ent_code};
        		var user_entity = { $pull: { "favor_infos": infoID} };
		    	updateuser(user_condition, user_entity, callback);
		    },
		    function(user_id, callback) {
		      	//更新板块
		      	var info_condition = { _id : infoID, ent_code : ent_code};
        		var info_entity = { $pull: { "favor_by": user_id} };
		        forumInfoService.updateByIdWithOptions(info_condition, info_entity, {upsert: true}, function(err, result) {
		            if (err) {
		                callback(err, null);
		            } else {
		                callback(null, null);
		            }
		        });
		    }
		], function (err, result) {
		    if (err) {
                res.json(returnCode.BUSY);
            } else {
                res.json(returnCode.SUCCESS);
            }
		});
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});


//收藏文章
router.post('/user/favorThread/:threadID', function(req, res, next) {
    var userID = user.getMobileUser(req);
    var ent_code = req.session.user.ent_code;
    var threadID = req.params.threadID;
    if (userID && threadID) {
        async.waterfall([
        	function(callback) {
		        queryIsFavor(userID, 'favor_threads', threadID, callback);
		    },
		    function(callback) {
		    	//更新用户
		    	var user_condition = { _id : userID, ent_code : ent_code};
        		var user_entity = { $push: { "favor_threads": threadID} };
		    	updateuser(user_condition, user_entity, callback);
		    },
		    function(user_id, callback) {
		      	//更新文章
		      	var thread_condition = { _id : threadID, ent_code : ent_code};
        		var thread_entity = { $push: { "favor_by": user_id} };
		        forumThreadService.updateByIdWithOptions(thread_condition, thread_entity, {upsert: true}, function(err, result) {
		            if (err) {
		                callback(err, null);
		            } else {
		                callback(null, null);
		            }
		        });
		    }
		], function (err, result) {
		    if (err) {
                if(err == 1){
		    		var rs = {
					  'errorcode': 1,
					  'errormsg': '已收藏'
					}
		    		res.json(rs);
		    	}else{
		    		res.json(returnCode.BUSY);
		    	}
            } else {
                res.json(returnCode.SUCCESS);
            }
		});
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});


//取消收藏文章
router.post('/user/disfavorThread/:threadID', function(req, res, next) {
    var userID = user.getMobileUser(req);
    var ent_code = req.session.user.ent_code;
    var threadID = req.params.threadID;
    if (userID && threadID) {
        async.waterfall([
		    function(callback) {
		    	//更新用户
		    	var user_condition = { _id : userID, ent_code : ent_code};
        		var user_entity = { $pull: { "favor_threads": threadID} };
		    	updateuser(user_condition, user_entity, callback);
		    },
		    function(user_id, callback) {
		      	//更新文章
		      	var thread_condition = { _id : threadID, ent_code : ent_code};
        		var thread_entity = { $pull: { "favor_by": user_id} };
		        forumThreadService.updateByIdWithOptions(thread_condition, thread_entity, {upsert: true}, function(err, result) {
		            if (err) {
		                callback(err, null);
		            } else {
		                callback(null, null);
		            }
		        });
		    }
		], function (err, result) {
		    if (err) {
                res.json(returnCode.BUSY);
            } else {
                res.json(returnCode.SUCCESS);
            }
		});
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//收藏用户
router.post('/user/favorUser/:favorUserID', function(req, res, next) {
    var userID = user.getMobileUser(req);// 收藏的用户
    var ent_code = req.session.user.ent_code;
    var favorUserID = req.params.favorUserID; //被收藏的用户
    if (userID && favorUserID) {
        async.waterfall([
        	function(callback) {
		        queryIsFavor(userID, 'favor_users', favorUserID, callback);
		    },
		    function(callback) {
		    	//更新用户
		    	var user_condition = { _id : userID, ent_code : ent_code};
        		var user_entity = { $push: { "favor_users": favorUserID} };
		        updateuser(user_condition, user_entity, callback);
		    },
		    function(user_id, callback) {
		      	//更新被收藏用户
		      	var favor_condition = { _id : favorUserID, ent_code : ent_code};
        		var favor_entity = { $push: { "favor_by": user_id} };
		        forumUserService.updateByIdWithOptions(favor_condition, favor_entity, {upsert: false}, function(err, result) {
		            if (err) {
		                callback(err, null);
		            } else {
		                callback(null, null);
		            }
		        });
		    }
		], function (err, result) {
		    if (err) {
		    	if(err == 1){
		    		var rs = {
					  'errorcode': 1,
					  'errormsg': '已收藏'
					}
		    		res.json(rs);
		    	}else{
		    		res.json(returnCode.BUSY);
		    	}
            } else {
                res.json(returnCode.SUCCESS);
            }
		});
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//取消收藏用户
router.post('/user/disfavorUser/:favorUserID', function(req, res, next) {
    var userID = user.getMobileUser(req);// 收藏的用户
    var ent_code = req.session.user.ent_code;
    var favorUserID = req.params.favorUserID; //被收藏的用户
    if (userID && favorUserID) {
        async.waterfall([
		    function(callback) {
		    	//更新用户
		    	var user_condition = { _id : userID, ent_code : ent_code};
        		var user_entity = { $pull: { "favor_users": favorUserID} };
		        updateuser(user_condition, user_entity, callback);
		    },
		    function(user_id, callback) {
		      	//更新被收藏用户
		      	var favor_condition = { _id : favorUserID, ent_code : ent_code};
        		var favor_entity = { $pull: { "favor_by": user_id} };
		        forumUserService.updateByIdWithOptions(favor_condition, favor_entity, {upsert: true}, function(err, result) {
		            if (err) {
		                callback(err, null);
		            } else {
		                callback(null, null);
		            }
		        });
		    }
		], function (err, result) {
		    if (err) {
                res.json(returnCode.BUSY);
            } else {
                res.json(returnCode.SUCCESS);
            }
		});
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});