'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//话题广场，板块
var ForumInfoSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	group: {
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumGroup'
	},
	name: { //论坛名称
		type: String,
		require: true
	},
	description: { //论坛简介
		type: String,
		require: true
	},
	icon: { //论坛图标
		type: String,
		require: true
	},
	order_idx: { //论坛排序
		type: Number,
		require: true,
		default: 0
	},
	pv_count: { //论坛访问量
		type: Number,
		require: true,
		default: 0
	},
	status: { //论坛状态，1启用，0禁用
		type: Number,
		require: true,
		default: 1
	},
	share_type:{//分享类型，1自定义，0和其它为默认
		type: Number,
		default: 0
	},
	share:{//desc title imgUrl
		type: Object,
		default:{}
	},
	created: {
	    type: Date,
	    required: true,
	    default:Date.now    
	}

}, {
	'collection': 'pisns_forum_info'
});


module.exports = mongoose.model('ForumInfo', ForumInfoSchema);