'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//用户收藏
var ForumFavoriteSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	user: { //收藏用户
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumUser'
	},
	title: { //收藏内容标题
		type: String,
		require: true
	},
	url: { //收藏链接地址
		type: String,
		require: true
	},
	created: { //收藏时间
		type: Date,
		require: true,
		default: Date.now
	}
}, {
	'collection': 'pisns_forum_favorite'
});


module.exports = mongoose.model('ForumFavorite', ForumFavoriteSchema);