'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
var ForumModeratorSchema=new Schema({
	ent_code:{
    	type: Number,
		require: true
    },
    info: {
		type: Schema.Types.ObjectId,
		require: false,
		index: true,
		ref: 'ForumInfo'
	},
    userName:{
    	type:String,
		require: false
    },
    content:{
        id:{type:String},
        content:{type:String}
    },
    behavior:{//行为：1.加精 2.取消精华 3.删帖
    	type: Number,
		require: false
    },
    moderatorName:{
    	type:String,
    	require:false
    },
	created:{
        type:Date,
        default: Date.now
    }
}, {
	'collection': 'pisns_forum_moderator_operation'
});

module.exports = mongoose.model('ForumModerator', ForumModeratorSchema);