'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//分享日志
var ForumShareLogSchema = new Schema({
	ent_code: {
        type: Number,
        require: true,
        index: true
    },
    user: { //访问者
        type: String,
        require: true,
        index: true,
        ref: 'ForumUser'
    },
    mid: { //会员ID
        type: Number,
        require: true,
        index: true
    },
    open_id: { //微信公众号唯一识别
        type: String,
        require: true,
        index: true
    },
    info: { //板块ID
        type: String,
        index: true,
        ref: 'ForumInfo'
    },
    thread: { //话题、文章、照片墙的ID
        type: String,
        index: true,
        ref: 'forumThread'
    },
    type: { //页面：1.主页  2.板块  3.文章
        type: Number,
        index: true,
        require: true
    },
    thread_type: { //文章类型：1.话题   2.文章   3.照片墙  4.子文章
        type: Number,
        index: true
    },
    share_type:{	//分享类型：1.微信朋友圈 2.微信单人 3.微信组
    	type: Number,
        index: true,
        require: true
    },
    p_thread: { //父文章ID
        type: String,
        index: true,
        ref: 'forumThread'
    },
    source: { //分享者
        type: String,
        require: true,
        index: true,
        ref: 'ForumUser'
    },
    ip: { //IP地址
        type: String
    },
    userAgent: {
        type: String
    },
    created: {
        type: Date,
        required: true,
        default: Date.now
    }
}, {
	'collection': 'pisns_forum_share_log'
});

module.exports = mongoose.model('ForumShareLog', ForumShareLogSchema);