'use strict';

var forumUserService=require('../service/forumUserService');

exports.getMobileUser=function(req){
	return req.session.mobileForumUser.userId;
	// return '55015675868b65a028187c49';
}

exports.getOpenId=function(req){
	return req.session.mobileForumUser.openId;
}
var updateUser = function(uid,nickName,icon,cb){
	var entity = {},
		isUpdate = false;
	if(nickName){
		entity.nickName = nickName;
		isUpdate = true;
	}
	if(icon){
		entity.icon = icon;
		isUpdate = true;
	}
	if(isUpdate){
		forumUserService.updateUserById(uid,entity,function(err,result){
			if(err){
				console.log(err);
			}
		});
	}
}
exports.identifyUser=function() {

	return function(req, res,next){
		if(!req.session.mobileForumUser){
			forumUserService.getUserByUid(req.session.openUser.openId,function(err,doc){
				if(err){
					next(err);
				}else{
					if(doc){
						updateUser(doc._id,req.session.openUser.nickName,req.session.openUser.icon,function(){});
						req.session.mobileForumUser={
							userId:doc._id,
							openId:doc.uid
						};
						if(req.session.source){
							if(req.session.source !== req.session.mobileForumUser.userId){
								req.session.mobileForumUser.source = req.session.source;
								delete req.session.source;		
							}
						}
						next(null);
					}else{
						if(req.session.tmpOpenId){
							next(null);
						}else{
							req.session.tmpOpenId=req.session.openUser.openId;
							var entity={
								uid:req.session.openUser.openId,
								nickName:req.session.openUser.nickName,
								icon:req.session.openUser.headPic,
								ent_code:req.session.user.ent_code
							};
							forumUserService.createUser(entity,function(err,doc){
								if(err){
									next(null);
								}else{
									req.session.mobileForumUser={
										userId:doc._id,
										openId:doc.uid
									};
									if(req.session.source){
										if(req.session.source !== req.session.mobileForumUser.userId){
											req.session.mobileForumUser.source = req.session.source;
											delete req.session.source;		
										}
									}

									next(null);
								}
							});
						}
					}
				}
			});
		}else{
			if(req.session.source){
				if(req.session.source !== req.session.mobileForumUser.userId){
					req.session.mobileForumUser.source = req.session.source;
					delete req.session.source;		
				}
			}
			next(null);
		}
		
	}

}