'use strict';

var mongoose = require('mongoose'),
    Schema = mongoose.Schema;
//行为限制中间表
var ForumLimitActionRefSchema = new Schema({
    ent_code: {
        type: Number,
        index: true,
        require: true
    },
    userId: { 
        type: String,
        index: true,
        unique:true,
        require: true
    },
    uid: { //用户ID，这里直接存放用户的openId
        type: String,
        require: false
    },
    status: { //状态，1启用，0禁用
        type: Number,
        require: true,
        default: 1
    },
    limit_actions: [{
        limit_action: {
            type: String,
            default: ''
        },
        limit_action_type: {
            type: String,
            default: ''
        },
        begin_time: {
            type: Date
        },
        end_time: {
            type: Date
        }
    }],
    created: {
        type: Date,
        required: true,
        default: Date.now
    }
}, {
    'collection': 'pisns_forum_limit_action_ref'
});


module.exports = mongoose.model('ForumLimitActionRef', ForumLimitActionRefSchema);
