'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//论坛访问控制，基于角色
var ForumAccessControlSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	forum: {
		type: Schema.Types.ObjectId,
		require: true,
		ref: 'ForumInfo'
	},
	role: { //角色
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumRole'
	},
	action: { //角色行为
		type: String,
		require: true,
		index: true
	},
	status: { //行为状态1，允许，2拒绝
		type: Number,
		require: true,
		default: 1
	}
}, {
	'collection': 'pisns_forum_access_control'
});

module.exports = mongoose.model('ForumAccessControl', ForumAccessControlSchema);