'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//举报
var ComplaintSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	content:{//被举报的文章，评论的内容
		type:String,
		require:false
	},
	complaintId:{//被举报的文章、评论的id
		type: String,
		require: true,
		index: true
	},
	complaintTo:{//被举报人
		type: Schema.Types.ObjectId,
		require: false,
		index: true,
		ref: 'ForumUser'
	},
	complaintFrom:{//举报人
		type: Schema.Types.ObjectId,
		require: false,
		index: true,
		ref: 'ForumUser'
	},
	type: { //被举报的是文章1 还是评论2
		type: Number,
		require: true,
		index: true
	},
	created: {
	    type: Date,
	    required: true,
	    default:Date.now    
	}
}, {
	'collection': 'pisns_forum_complaint'
});

module.exports = mongoose.model('ForumComplaint', ComplaintSchema);