'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;

//收藏的板块
var ForumFollowInfoSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	from: { 
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumUser'
	},
	info: { 
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumInfo'
	},
	created: {
	    type: Date,
	    required: true,
	    default:Date.now    
	}
}, {
	'collection': 'pisns_forum_follow_info'
});

module.exports = mongoose.model('ForumFollowInfo', ForumFollowInfoSchema);