'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//话题广场，板块
var ForumNoticeSchema = new Schema({
			ent_code: {			   //企业号
				type: Number,
				default: '',
				index: true
			},
			plate: {					//所属板块
				type: Schema.Types.ObjectId,
				require: true,
				index: true,
				ref: 'ForumInfo'
			},
			type:{				  //1/2 活动 消息
				type: Number,
				default: 1,
				index: true
			},
			label: {			   //标签
				type: String,
				require: true,
				default:''
			},
			title: {				//标题
				type: String,
				require:true
			},
			desc: {					//描述
				type: String,
				require:true
			},
			content:{
				type:String,		//正文
				require:false	 			
			},
			readnum:{				//阅读数	
				type: Number,
				default:0
			},
			creater: {				//创建人
				type: String,
				require:true
			},
			startdate: {			//开始时间，默认当前时间
				type: Date,
				default:''
			},
			indate: {				//有效期限，不填就默认永久
				type: Date,
				default:''
			},
			createtime: {			//创建时间，当前时间
				type: Date,
				default: Date.now
			},
			top: {					// 置顶0/1 默认0
				type: Number,
				default: 0,
				index: true
			},
			order_idx: { //排序
				type: Number,
				require: true,
				default: 0
			},
			status: {				//是否显示  0/1 隐藏/显示
				type: Number,
				require: true,
				default: 1,
				index: true
			},
			finished: {				//是否结束  0/1 否/是
				type: Number,
				require: true,
				default: 0,
				index: true
			}

}, {
	'collection': 'pisns_forum_notice'
});

module.exports = mongoose.model('ForumNotice', ForumNoticeSchema);