'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	_ = require('lodash');
var mongoose = require('mongoose');

var ForumHonorTitle = mongoose.model('ForumHonorTitle');

var forumHonorTitleService=require('../../service/forumHonorTitleService');
var redisThreadList = require('../../utils/redisThreadList');
module.exports = function(app) {
	app.use('/admin/forum', router);
};

//新增
router.post('/honorTitle/create', function(req, res, next) {
	var rs = {};
	req.body.ent_code=req.session.user.ent_code;
	forumHonorTitleService.create(req.body,function(err,entity){
		if (err) {
			console.error(err);
			res.json(returnCode.BUSY);
		} else {
			rs.data = {'id':entity._id};
			res.json(_.assign(rs, returnCode.SUCCESS));
		}
	});
});


//删除
router.post('/honorTitle/:id/delete', function(req, res, next) {
	var id=req.params.id;
	if(id){
		forumHonorTitleService.deleteById(id,function(err,entity){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				res.json(returnCode.SUCCESS);
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

//更新
router.post('/honorTitle/:id/update', function(req, res, next) {
	var id=req.params.id;
	var entity = req.body;
	if(id && entity){
		forumHonorTitleService.updateById(id,entity,function(err,entity){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				res.json(returnCode.SUCCESS);
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

//获取
router.get('/honorTitle/:id/get', function(req, res, next) {
	var id = req.params.id || null;
	var rs = {};
	if (id) {
		forumHonorTitleService.getById(id,function(err,entity){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				rs.data = entity;
				res.json(_.assign(rs, returnCode.SUCCESS));
			}
		});
	} else {
		res.json(returnCode.WRONG_PARAM);
	}
});

//直接修改序号
router.put('/honorTitle/orderIDX/:id/:order', function(req, res, next) {
	var id=req.params.id;
    var idx=req.params.order;
	forumHonorTitleService.updateIdx(id,idx,function(err,result){
		if(err ||　!result){
			return res.json(returnCode.BUSY);
		}
		return res.json(_.assign({data:true}, returnCode.SUCCESS));
	});
});

//上移
router.put('/honorTitle/moveUP/:id/:order', function(req, res, next) {
	var id=req.params.id;
	var idx=req.params.order;
	var titleName=req.query.titleName || '';

	var conditions={
		ent_code:req.session.user.ent_code
	};
	if(tagName){
		conditions.title={
			$regex: titleName,
			$options: 'i'
		};
	}
	forumHonorTitleService.getAllOrderIDX(conditions,function(err,results){
		if(err){
			return res.json(returnCode.BUSY);
		}
		var index=-1;
		_.forEach(results,function(r,i){
			if(r._id.toString() === id.toString()){
				index=i;
			}
		});
		if(index === -1){
			return res.json(returnCode.BUSY);
		}
		var preObj=results[index-1];
		if(!preObj){
			return res.json(returnCode.BUSY);
		}
		var preidx=preObj.order_idx;
		if(preidx.toString() === idx.toString()){
			preidx = Number(preidx)+1;
		}
		forumHonorTitleService.updateIdx(id,preidx,function(err,result){
			if(err ||　!result){
				return res.json(returnCode.BUSY);
			}
			forumHonorTitleService.updateIdx(preObj._id,idx,function(err,result){
				if(err ||　!result){
					return res.json(returnCode.BUSY);
				}
				return res.json(_.assign({data:true}, returnCode.SUCCESS));
			});
		});
	});
});

//查询列表
router.get('/honorTitle/searchList', function(req, res, next) {
	var pageNo = req.query.pageNo || 1,
    	pageSize = req.query.pageSize || 10,
    	titleName=req.query.titleName || '';

    var conditions={
    	ent_code:req.session.user.ent_code
    };
    if(titleName){
    	conditions.title={
    		$regex: titleName,
			$options: 'i'
    	};
    }
	forumHonorTitleService.getAll(conditions,pageNo,pageSize,function(err,results){
		if(err){
			console.error(err);
			res.json(returnCode.BUSY);
		}else{
			res.json(_.assign(results, returnCode.SUCCESS));
		}
	});
});

//获取状态为启用的
router.get('/honorTitle/list', function(req, res, next) {

    var conditions={
    	ent_code:req.session.user.ent_code,
    	status:1
    };
	forumHonorTitleService.find(conditions, function(err,results){
		if(err){
			console.error(err);
			res.json(returnCode.BUSY);
		}else{
			var rs = {
				data:results
			};
			res.json(_.assign(rs, returnCode.SUCCESS));
		}
	});
});
