'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	then = require('thenjs'),
	async = require('async'),
	_ = require('lodash');
var mongoose = require('mongoose');

var ForumMessage = mongoose.model('ForumMessage');

var forumMessageService=require('../../service/forumMessageService');
var forumUserService=require('../../service/forumUserService');

module.exports = function(app) {
	app.use('/admin/forum', router);
};

//新增
router.post('/message/create', function(req, res, next) {
	var object = req.body;
	var ent_code = req.session.user.ent_code;
	var uid = req.session.user.id;
	object.ent_code = ent_code;
	object.fromUsername = req.session.user.username;
	object.fromNickName = req.session.user.nickName;
	var to_user_ids = object.to; //接受者ID
	if(to_user_ids){
		async.waterfall([
			function(callback) { //获取管理员信息
	            forumUserService.getUserByUid(uid, function(err, user){
	            	if(err){
	            		callback(err,null);
	            	}else if(user){
	            		callback(null,user._id);
	            	}else{
	            		callback(null,'');
	            	}
	            });
	        },
	        function(userID, callback) { //创建消息
	        	object.from = userID;
	            forumMessageService.create(object,function(err,doc){
					if (doc) {
	                    callback(null, doc._id);
	                } else {
	                    callback(null, null);
	                }
				});
	        },
	        function(message_id, callback) { //更新用户消息
	        	var obj_msg = {
	        		msg:message_id,
	        		status:0
	        	}
	        	var entity = {
	        		$push:{messages:obj_msg}
	        	}
	        	var update_tasks = [];
		        _.forEach(to_user_ids, function(id) {
		            update_tasks.push(function(cont) {
		                var match = {
		                    ent_code:object.ent_code,
		                    _id: new mongoose.Types.ObjectId(id)
		                }
		                forumUserService.updateUserById(match, entity,function(err,doc){
							if (err) {
			                    cont(err, null);
			                } else {
			                    cont(null, doc);
			                }
						});
		            });
		        });
	            then.parallel(update_tasks).then(function(cont, datas) {
	                callback(null, null);
	            }).fail(function(err, cont) {
	                callback(err, null);
	            });
	        }
	    ], function(err, result) {
	        if (err) {
	            console.error(err);
	            res.json(returnCode.BUSY);
	        } else {
	            res.json(returnCode.SUCCESS);
	        }
	    });
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

//获取
router.get('/message/:id/get', function(req, res, next) {
	var id = req.params.id || null;
	var rs = {};
	if (id) {
		forumMessageService.getById(id,function(err,entity){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				rs.data = entity;
				res.json(_.assign(rs, returnCode.SUCCESS));
			}
		});
	} else {
		res.json(returnCode.WRONG_PARAM);
	}
});

//删除
router.post('/message/:id/delete', function(req, res, next) {
	var msgID=req.params.id;
	var ent_code = req.session.user.ent_code;
	if(msgID){
	    async.waterfall([
			function(callback) { 
	            //获取用户IDs
			    var q = {
			        ent_code: ent_code,
			        _id:msgID
			    }
			    forumMessageService.getMessageToNotPage(q, function(err, result) {
			        if (err) {
	                    callback(err, null);
	                } else {
	                    callback(null, result);
	                }
			    });
	        },
	        function(userIDs, callback) { //更新用户消息
	        	var entity = { $pull: { 'messages': { msg: msgID } } }
	        	var pull_tasks = [];
		        _.forEach(userIDs, function(id) {
		            pull_tasks.push(function(cont) {
		                var match = {
		                    ent_code:ent_code,
		                    _id: id
		                }
		                forumUserService.updateUserById(match, entity,function(err,doc){
							if (err) {
			                    cont(err, null);
			                } else {
			                    cont(null, doc);
			                }
						});
		            });
		        });
	            then.parallel(pull_tasks).then(function(cont, datas) {
	                callback(null, null);
	            }).fail(function(err, cont) {
	                callback(err, null);
	            });
	        },
	        function(message_id, callback) { //删除消息   
			    forumMessageService.deleteById(msgID,function(err,entity){
					if (err) {
                        console.error(err);
                        callback(err, null);
                    } else {
                        callback(null, null);
                    }
				});
	        }
	    ], function(err, result) {
	        if (err) {
	            console.error(err);
	            res.json(returnCode.BUSY);
	        } else {
	            res.json(returnCode.SUCCESS);
	        }
	    });
    }else{
    	res.json(returnCode.WRONG_PARAM);
    }
});

//更新
router.post('/message/:id/update', function(req, res, next) {
	var id=req.params.id;
	var entity = req.body;
	if(id && entity){
		forumMessageService.update({_id:id},entity,function(err,entity){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				res.json(returnCode.SUCCESS);
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});


//查询列表
router.get('/message/searchList', function(req, res, next) {
	var pageNo = req.query.pageNo || 1,
    	pageSize = req.query.pageSize || 10,
    	ent_code = req.session.user.ent_code,
    	title = req.query.title || null,
    	content = req.query.content || null,
    	begin_time = req.query.begin_time || null,
    	end_time = req.query.end_time || null;

    //查询用户条件
    var q = {
        ent_code: ent_code
    }
    if(title){
		q.title = {
            $regex: title,
        	$options: 'i'
        };
	}

	if(content){
		q.content = {
            $regex: content,
        	$options: 'i'
        };
	}

	if(begin_time && end_time){
		q.created = {
            $gte: begin_time,
            $lte: end_time
        }
    }else if(begin_time && !end_time){
    	q.created = {
            $gte: begin_time
        }
    }else if(!begin_time && end_time){
    	q.created = {
            $lte: end_time
        }
    }

    forumMessageService.getAll(q, pageNo, pageSize, function(err, result) {
        if (err) {
			console.error(err);
			res.json(returnCode.BUSY);
		} else {
			res.json(_.assign(result, returnCode.SUCCESS));
		}
    });
   	
});

//获取消息的用户列表
router.get('/message/:id/userList', function(req, res, next) {
	var pageNo = req.query.pageNo || 1,
    	pageSize = req.query.pageSize || 10,
    	id = req.params.id,
    	ent_code = req.session.user.ent_code;

    if(id){
    	//查询用户条件
	    var q = {
	        ent_code: ent_code,
	        _id:id
	    }
	    forumMessageService.getMessageTo(q, pageNo, pageSize, function(err, result) {
	        if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				res.json(_.assign(result, returnCode.SUCCESS));
			}
	    });
    }else{
    	res.json(returnCode.WRONG_PARAM);
    }
});