'use strict';
var express = require('express'),
    router = express.Router(),
    user = require('../../utils/user'),
    util = require('../../utils/util'),
    returnCode = require('../../utils/returnCode'),
    _ = require('lodash');
var forumAboutMEService = require('../../service/forumAboutMEService');


module.exports = function(app) {
    app.use('/v1/forum', router);
};

router.get('/aboutme/me2other', function(req, res, next) {
    var userId = user.getMobileUser(req);
    var entcode = req.session.user.ent_code;
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    console.log(userId);
    console.log(entcode);
    forumAboutMEService.me2other(entcode, userId, pageNo, pageSize, function(err, result) {
        if (err) {
            res.json(returnCode.UNCHECK_ERROR(err));
        } else {
            util.loadLevel(req.session.user.ent_code,result.items,function(){
                res.json(_.assign(result, returnCode.SUCCESS));
            });
        }
    });
});

router.get('/aboutme/other2me', function(req, res, next) {
    var userId = user.getMobileUser(req);
    var entcode = req.session.user.ent_code;
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    console.log(userId);
    console.log(entcode);
    forumAboutMEService.other2me(entcode, userId, pageNo, pageSize, function(err, results) {
        if (err) {
            res.json(returnCode.UNCHECK_ERROR(err));
        } else {
            _.forEach(results.items, function(d, i) {
                if (results.items[i].toObject) {
                    results.items[i] = results.items[i].toObject();
                }
                //获取等级最高的荣誉
                if(results.items[i].from && results.items[i].from.honorTitles && results.items[i].from.honorTitles.length > 0){
                    var temp_honorTitles = _.sortBy(results.items[i].from.honorTitles, 'order_idx')
                    for(var m = temp_honorTitles.length - 1; m >= 0; m-=1){
                        var honor = temp_honorTitles[m]
                        if(honor.is_show == 1){
                            results.items[i].from.honorTitles = honor;
                            break;
                        }
                    }
                }
            });

            util.loadLevel(req.session.user.ent_code,results.items,function(){
                res.json(_.assign(results, returnCode.SUCCESS));
            });
        }
    });
});

router.get('/aboutme/he2other/:id/:entcode', function(req, res, next) {
    var userId = req.params.id;
    var entcode = req.params.entcode;
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    forumAboutMEService.me2other(entcode, userId, pageNo, pageSize, function(err, result) {
        if (err) {
            res.json(returnCode.UNCHECK_ERROR(err));
        } else {
            res.json(_.assign(result, returnCode.SUCCESS));
        }
    });
});

router.get('/aboutme/other2he/:id/:entcode', function(req, res, next) {
    var userId = req.params.id;
    var entcode = req.params.entcode;
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    forumAboutMEService.other2me(entcode, userId, pageNo, pageSize, function(err, result) {
        if (err) {
            res.json(returnCode.UNCHECK_ERROR(err));
        } else {
            res.json(_.assign(result, returnCode.SUCCESS));
        }
    });
});
