'use strict';
var express = require('express'),
    router = express.Router(),
    returnCode = require('../../utils/returnCode'),
    util = require('../../utils/util'),
    loadUserLevel = require('../../utils/loadUserLevel'),
    async = require('async'),
    _ = require('lodash');
var mongoose = require('mongoose');
var ForumThread = mongoose.model('ForumThread');
var ForumComment = mongoose.model('ForumComment');

var forumThreadService = require('../../service/forumThreadService');
var forumRolePermissionService = require('../../service/forumRolePermissionService');
var forumPraiseLogService = require('../../service/forumPraiseLogService');
var forumShareLogService = require('../../service/forumShareLogService');
var forumCommentService = require('../../service/forumCommentService');
var forumUserThreadControlService = require('../../service/forumUserThreadControlService');
var forumLimitOperationService = require('../../service/forumLimitOperationService');
var forumThreadAttendService = require('../../service/forumThreadAttendService');
var forumUserService = require('../../service/forumUserService');
var commentTips = require('../../utils/commentTips');
var redisPraiseLog = require('../../utils/redisPraiseLog');
var httpService = require('../../service/httpService');
var forumAboutMEService = require('../../service/forumAboutMEService');
var user = require('../../utils/user');
var floorGenerator = require('../../utils/floorGenerator');
var async = require('async');
var ForumModeratorApply = mongoose.model('ForumModeratorApply');
var forumModeratorApplyService = require('../../service/forumModeratorApplyService');
var redisThreadList = require('../../utils/redisThreadList');

var forumFollowThreadService = require('../../service/forumFollowThreadService');
var forumFollowInfoService = require('../../service/forumFollowInfoService');
var forumFollowUserService = require('../../service/forumFollowUserService');

module.exports = function(app) {
    app.use('/v1/forum', router);
};

function create(req, callback) {
    var entity = req.body;

    if (entity.pid == '') {
        entity.pid = null;
    }

    var address = entity.address || null;
    if (address) {
        entity.address = JSON.parse(address);
    }

    entity.ent_code = req.session.user.ent_code;
    entity.from = user.getMobileUser(req);

    //-----------处理前端上传图片开始
    //格式为['http://imageurl','http://imageurl'],
    //转换为[{urlFileName:'http://imageUrL'},{urlFileName:'http://imageUrL'}]
    var images = entity.images;
    if (images) {
        var array = [];
        for (var i = 0; i < images.length; i = i + 1) {
            array.push({
                urlFileName: images[i]
            });
        }
        entity.images = array;
    }
    //-----------处理前端上传图片结束

    //校验是否全是表情
    var temp_content = entity.content;
    temp_content = temp_content.replace(/<img\/?.+?border="0">/g,"");

    if(!temp_content || temp_content.length < 1){
        callback('content error', null);
    } else if (entity.pid && entity.type == 3) {
        forumThreadService.getByConditions({
            type: 3,
            level: '2',
            pid: entity.pid,
            from: entity.from,
            status: 1
        }, function(err, doc) {
            if (doc) {
                var update = {
                    $set: {
                        images: entity.images,
                        content: entity.content,
                        tag: entity.tag,
                        address: entity.address,
                        title: entity.title
                    }
                };
                forumThreadService.updateThreadById(doc._id, update, function(err, updatedDoc) {
                    callback(err, entity);
                });
            } else {
                forumThreadService.createThread(entity, function(err, entity) {
                    if (err) {
                        console.error(err);
                        callback(err, null);
                    } else {
                        callback(null, entity);
                    }
                });
            }
        });
    } else {
        forumThreadService.createThread(entity, function(err, entity) {
            if (err) {
                console.error(err);
                callback(err, null);
            } else {
                callback(null, entity);
            }
        });
    }
}

//点赞和取消点赞
var raiseOrcancelRaise = function(req, ent_code, tid, userId, callback) {
    //判断是否已经点赞
    forumPraiseLogService.queryPraiseLog(tid, null, userId, 1, function(err, doc) {
        if (err) {
            res.json(returnCode.BUSY);
        } else {
            forumThreadService.getThreadById(tid, function(err, thread) {
                if (err) {
                    callback(returnCode.BUSY);
                } else if (!doc || doc.status == 1) {
                    //点赞
                    async.parallel([
                        function(callback) {
                            //3.更新文章统计数据(点赞数)
                            if (thread) {
                                forumThreadService.updateThreadRaiseCount(tid, function(err, cb) {
                                    if (err) {
                                        callback(err, null);
                                    } else {
                                        callback(null, null);
                                    }
                                });
                            } else {
                                callback('cannot find thread by id', null);
                            }
                        },
                        function(callback) {
                            if (doc) { //如果已存在，更新为点赞日志
                                forumPraiseLogService.updatePraiseLog(doc._id, 0, function(err, result) {
                                    if (err) {
                                        callback(err, null);
                                    } else {
                                        callback(null, null);
                                    }
                                });
                            } else { //不存在，创建点赞日志
                                var entity = {
                                    ent_code: ent_code,
                                    user: userId,
                                    thread: tid,
                                    ip: req.ip,
                                    comment: null,
                                    type: 1,
                                    status: 0
                                };
                                //4.创建点赞日志
                                forumPraiseLogService.createPraiseLog(entity, function(err, result) {
                                    if (err) {
                                        callback(err, null);
                                    } else {
                                        callback(null, null);
                                    }
                                });
                            }
                        }
                    ], function(err, results) {
                        if (err) {
                            console.error(err);
                            // res.json(returnCode.BUSY);
                            callback(returnCode.BUSY);
                        } else {
                            //更新点赞redis
                            redisPraiseLog.get(ent_code, userId, 'thread', function(error, docs) {
                                var list = docs;
                                list.push(tid);
                                redisPraiseLog.set(ent_code, userId, 'thread', list, function() {});
                            });

                            forumThreadService.getThreadById(tid, function(err, doc) {
                                if (err) {
                                    console.error(err);
                                    // res.json(returnCode.BUSY);
                                    callback(returnCode.BUSY);
                                } else {
                                    var rs = {};
                                    rs.praise_count = doc.praise_count;
                                    rs.isPraise = true;
                                    callback(_.assign(rs, returnCode.SUCCESS));
                                }
                            });
                        }
                    });
                } else if (doc && doc.status == 0) { 
                    //取消点赞
                    async.parallel([
                        function(callback) {
                            //3.更新文章统计数据(点赞数)
                            if (thread && thread.praise_count > 0) {
                                forumThreadService.updateThreadRaiseCountDec(tid, function(err, cb) {
                                    if (err) {
                                        callback(err, null);
                                    } else {
                                        callback(null, null);
                                    }
                                });
                            } else {
                                callback('cannot find thread by id', null);
                            }
                        },
                        function(callback) {
                            //4.更新点赞日志
                            forumPraiseLogService.updatePraiseLog(doc._id, 1, function(err, result) {
                                if (err) {
                                    callback(err, null);
                                } else {
                                    callback(null, null);
                                }
                            });
                        }
                    ], function(err, results) {
                        if (err) {
                            console.error(err);
                            callback(returnCode.BUSY);
                        } else {
                            //更新点赞redis
                            redisPraiseLog.get(ent_code, userId, 'thread', function(error, docs) {
                                var list = docs;
                                for (var i = 0; i < list.length; i++) {
                                    if (list[i].toString() == tid) {
                                        list.splice(i, 1);
                                        break;
                                    }
                                }
                                redisPraiseLog.set(ent_code, userId, 'thread', list, function() {});
                            });

                            forumThreadService.getThreadById(tid, function(err, doc) {
                                if (err) {
                                    console.error(err);
                                    callback(returnCode.BUSY);
                                } else {
                                    var rs = {};
                                    rs.praise_count = doc.praise_count;
                                    rs.isPraise = false;
                                    callback(_.assign(rs, returnCode.SUCCESS));
                                }
                            });
                        }
                    });
                } else {
                    callback(returnCode.BUSY);
                }
            });
        }
    });
}

//评论点赞和取消点赞
var conmentRaiseOrcancelRaise = function(req, ent_code, tid, cid, userId, callback) {
    forumPraiseLogService.queryPraiseLog(tid, cid, userId, 2, function(err, doc) {
        if (err) {
            console.error(err);
            callback(returnCode.BUSY);
        } else {
            //2.获取论坛文章
            forumThreadService.getThreadById(tid, function(err, thread) {
                if (err) {
                    callback(returnCode.BUSY);
                } else if(!doc || doc.status == 1){
                    //点赞
                    async.parallel([
                        function(callback) {
                            forumCommentService.updatePraiseCount(cid, function(err, results) {
                                if (err) {
                                    console.log(err);
                                    callback(err, null);
                                } else {
                                    callback(null, null);
                                }
                            });
                        },
                        function(callback) {
                            if (doc) {
                                //4.更新点赞日志
                                forumPraiseLogService.updatePraiseLog(doc._id, 0, function(err, result) {
                                    if (err) {
                                        callback(err, null);
                                    } else {
                                        callback(null, null);
                                    }
                                });
                            } else {
                                var entity = {
                                    ent_code: ent_code,
                                    user: userId,
                                    thread: tid,
                                    ip: req.ip,
                                    comment: cid,
                                    type: 2,
                                    status: 0
                                };
                                //4.创建点赞日志
                                forumPraiseLogService.createPraiseLog(entity, function(err, result) {
                                    if (err) {
                                        callback(err, null);
                                    } else {
                                        callback(null, null);
                                    }
                                });
                            }
                        }
                    ], function(err, results) {
                        if (err) {
                            console.error(err);
                            callback(returnCode.BUSY);
                        } else {

                            //更新点赞redis
                            redisPraiseLog.get(ent_code, userId, 'comment', function(error, docs) {
                                var list = docs;
                                list.push(cid);
                                redisPraiseLog.set(ent_code, userId, 'comment', list, function() {});
                            });
                            //返回点赞总数
                            forumCommentService.getCommentById(cid, function(err, doc) {
                                if (err) {
                                    console.error(err);
                                    callback(returnCode.BUSY);
                                } else {
                                    var rs = {};
                                    rs.praise_count = doc.praise_count;
                                    rs.isPraise = true;
                                    callback(_.assign(rs, returnCode.SUCCESS));
                                }
                            });

                        }
                    });
                } else if(doc && doc.status == 0){
                    //取消点赞
                    async.parallel([
                        function(callback) {
                            forumCommentService.updatePraiseCountDec(cid, function(err, results) {
                                if (err) {
                                    console.log(err);
                                    callback(err, null);
                                } else {
                                    callback(null, null);
                                }
                            });
                        },
                        function(callback) {
                            //4.更新点赞日志
                            forumPraiseLogService.updatePraiseLog(doc._id, 1, function(err, result) {
                                if (err) {
                                    callback(err, null);
                                } else {
                                    callback(null, null);
                                }
                            });
                        }
                    ], function(err, results) {
                        if (err) {
                            console.error(err);
                            callback(returnCode.BUSY);
                        } else {
                            //更新点赞redis
                            redisPraiseLog.get(ent_code, userId, 'comment', function(error, docs) {
                                var list = docs;
                                for (var i = 0; i < list.length; i++) {
                                    if (list[i].toString() == cid) {
                                        list.splice(i, 1);
                                        break;
                                    }
                                }
                                redisPraiseLog.set(ent_code, userId, 'comment', list, function() {});
                            });
                            //返回点赞总数
                            forumCommentService.getCommentById(cid, function(err, doc) {
                                if (err) {
                                    console.error(err);
                                    res.json(returnCode.BUSY);
                                } else {
                                    var rs = {};
                                    rs.praise_count = doc.praise_count;
                                    rs.isPraise = false;
                                    callback(_.assign(rs, returnCode.SUCCESS));
                                }
                            });
                        }
                    });
                } else{
                    callback(returnCode.BUSY);
                }
            });
        }
    });
}

//根据发帖者分页查询话题列表
router.get('/thread/searchThread', function(req, res, next) {

    //参数
    var pageNo = req.query.pageNo,
        pageSize = req.query.pageSize,
        from = req.session.mobileForumUser.userId,
        status = 1,
        ent_code = req.session.user.ent_code;

    var today = new Date();
    if (pageNo && pageSize) {
        var q = {
            ent_code: ent_code,
            status: status,
            from: from,
            $or: [{
                isEvent: {
                    $ne:1
                }
            }, {
                isEvent: 1,
                'event.eventStartTime' : {$lte : today},
                'event.eventEndTime' : {$gte : today}
            }]
        };

        forumThreadService.findThreadByPage(pageNo, pageSize, q, function(err, result) {
            if (err) {
                console.error(err);
            }
            res.json(result);
        });
    } else {
        console.error('params error');
        res.json({
            result: false,
            err: 'params error'
        });
    }
});

//文章评论
router.get('/thread/searchComment', function(req, res, next) {

    //参数
    var pageNo = req.query.pageNo,
        pageSize = req.query.pageSize,
        from = req.session.mobileForumUser.userId,
        // status = 1,
        ent_code = req.session.user.ent_code;

    if (pageNo && pageSize) {
        var q = {
            ent_code: ent_code,
            // status: status,
            from: req.session.mobileForumUser.from
        };

        forumThreadService.findCommentByPage(pageNo, pageSize, q, function(err, result) {
            if (err) {
                console.error(err);
            }
            res.json(result);
        });
    } else {
        console.error('params error');
        res.json({
            result: false,
            err: 'params error'
        });
    }
});

//新增论坛文章
router.post('/thread/create', function(req, res, next) {
    var userId = req.session.mobileForumUser.userId;
    forumLimitOperationService.checkLimitOperationProhibitionOfSpeech(userId, function(err, isProhibition) {
        if (err) {
            console.error(err);
            res.json(returnCode.PROHIBITION_OF_SPEECH);
        } else {
            if (isProhibition) {
                res.json(returnCode.PROHIBITION_OF_SPEECH);
            } else {
                var integral = req.session.openUser.integral || 0;
                var exp = req.session.openUser.exp || 0;
                forumRolePermissionService.checkRolePermiss(req.session.user.ent_code, 'create', integral, exp, function(err, result) {
                    if (err) {
                        console.error(err);
                        res.json(returnCode.BUSY);
                    } else {
                        if (result) { //有操作权限
                            create(req, function(err, thread) {
                                if (err) {
                                    console.error(err);
                                    res.json(_.assign(err, returnCode.BUSY));
                                } else {
                                    forumAboutMEService.saveThread(thread);
                                    forumLimitOperationService.checkLimitOperationProhibitionAddIntegral(userId, function(err, flag) {
                                        if (err) {
                                            console.error(err);
                                        } else {
                                            if (!flag) {
                                                httpService.sendRequest(req.session.user.ent_code, req.session.openUser.mid, 'post');
                                            }
                                        }
                                    });
                                    var rs = {};
                                    rs.data = {
                                        'id': thread._id
                                    };
                                    res.json(_.assign(rs, returnCode.SUCCESS));
                                }
                            });
                        } else {
                            res.json(returnCode.ACTION_NOT_PERMISSION);
                        }
                    }
                });
            }
        }
    });
});

//获取文章
router.get('/thread/:tid/get', function(req, res, next) {
    var tid = req.params.tid || null;
    var ent_code = req.session.user.ent_code;

    if (tid) {
        async.waterfall([         
            function(callback) {
                forumThreadService.getThreadById(tid, function(err, thread) {
                    //文章类型 1、文章 2、话题 3、照片墙
                    if (err) {
                        callback(err, null);
                    } else {
                        callback(null, thread);
                    }
                    if(thread && thread.info){
                        var info_id = thread.info._id,
                            pid = thread.pid,
                            source = req.session.mobileForumUser.source;
                        if (thread.type == 1 && thread.level == 1) {
                            httpService.createLog(req, source, info_id, 3, 1, tid);
                        } else if (thread.type == 1 && thread.level == 2) {
                            httpService.createLog(req, source, info_id, 3, 4, tid, pid);
                        } else if (thread.type == 2 && thread.level == 1) {
                            httpService.createLog(req, source, info_id, 3, 2, tid);
                        } else if (thread.type == 3 && thread.level == 1) {
                            httpService.createLog(req, source, info_id, 3, 3, tid);
                        }   
                    }
                });
                forumThreadService.updateThreadPvCount(tid, function(err, doc) {
                    if (err) {
                        console.error(err);
                    } 
                });
            },
        ], function(err, thread) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                if (thread.toObject) {
                    thread = thread.toObject();
                }
                var threads = [];
                threads.push(thread);
                util.loadLevel(req.session.user.ent_code, threads, function() {
                    if (threads && threads.length > 0) {
                        thread = threads[0];
                    }
                    if (thread.type == 2 && thread.level == 1&&thread.subThreads.items.length>0) {
                        util.loadLevel(req.session.user.ent_code, thread.subThreads.items, function() {
                            redisPraiseLog.get(ent_code, user.getMobileUser(req), 'thread', function(error, docs) {
                                if (thread.toObject) {
                                    thread = thread.toObject();
                                }
                                thread.isPraise = false;
                                for (var k = docs.length - 1; k >= 0; k--) {
                                    if (thread._id == docs[k]) {
                                        thread.isPraise = true;
                                        break;
                                    }
                                };
                                var rs = {};
                                rs.data = thread;
                                res.json(_.assign(rs, returnCode.SUCCESS));
                            });
                        });
                    } else {
                        redisPraiseLog.get(ent_code, user.getMobileUser(req), 'thread', function(error, docs) {
                            if (thread.toObject) {
                                thread = thread.toObject();
                            }
                            thread.isPraise = false;
                            for (var k = docs.length - 1; k >= 0; k--) {
                                if (thread._id == docs[k]) {
                                    thread.isPraise = true;
                                    break;
                                }
                            };
                            var rs = {};
                            rs.data = thread;
                            res.json(_.assign(rs, returnCode.SUCCESS));
                        });
                    }
                });

            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//获取文章,二级评论只查询三条
router.get('/thread/:tid/getV2', function(req, res, next) {
    var tid = req.params.tid || null;
    var ent_code = req.session.user.ent_code;

    if (tid) {
        async.waterfall([         
            function(callback) {
                forumThreadService.getThreadByIdWithThree2Comment(tid, function(err, thread) {
                    //文章类型 1、文章 2、话题 3、照片墙
                    if (err) {
                        callback(err, null);
                    } else {
                        callback(null, thread);
                    }
                    if(thread && thread.info){
                        var info_id = thread.info._id,
                            pid = thread.pid,
                            source = req.session.mobileForumUser.source;
                        if (thread.type == 1 && thread.level == 1) {
                            httpService.createLog(req, source, info_id, 3, 1, tid);
                        } else if (thread.type == 1 && thread.level == 2) {
                            httpService.createLog(req, source, info_id, 3, 4, tid, pid);
                        } else if (thread.type == 2 && thread.level == 1) {
                            httpService.createLog(req, source, info_id, 3, 2, tid);
                        } else if (thread.type == 3 && thread.level == 1) {
                            httpService.createLog(req, source, info_id, 3, 3, tid);
                        }   
                    }
                });
                forumThreadService.updateThreadPvCount(tid, function(err, doc) {
                    if (err) {
                        console.error(err);
                    } 
                });
            },
        ], function(err, thread) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                if (thread.toObject) {
                    thread = thread.toObject();
                }
                var threads = [];
                threads.push(thread);
                util.loadLevel(req.session.user.ent_code, threads, function() {
                    if (threads && threads.length > 0) {
                        thread = threads[0];
                    }
                    if (thread.type == 2 && thread.level == 1&&thread.subThreads.items.length>0) {
                        util.loadLevel(req.session.user.ent_code, thread.subThreads.items, function() {
                            redisPraiseLog.get(ent_code, user.getMobileUser(req), 'thread', function(error, docs) {
                                if (thread.toObject) {
                                    thread = thread.toObject();
                                }
                                thread.isPraise = false;
                                for (var k = docs.length - 1; k >= 0; k--) {
                                    if (thread._id == docs[k]) {
                                        thread.isPraise = true;
                                        break;
                                    }
                                };
                                var rs = {};
                                rs.data = thread;
                                res.json(_.assign(rs, returnCode.SUCCESS));
                            });
                        });
                    } else {
                        redisPraiseLog.get(ent_code, user.getMobileUser(req), 'thread', function(error, docs) {
                            if (thread.toObject) {
                                thread = thread.toObject();
                            }
                            thread.isPraise = false;
                            for (var k = docs.length - 1; k >= 0; k--) {
                                if (thread._id == docs[k]) {
                                    thread.isPraise = true;
                                    break;
                                }
                            };
                            var rs = {};
                            rs.data = thread;
                            res.json(_.assign(rs, returnCode.SUCCESS));
                        });
                    }
                });

            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//获取文章
router.get('/thread/photo/:pid/get', function(req, res, next) {
    var pid = req.params.pid || null,
        userId = user.getMobileUser(req);
    if (pid) {
        forumThreadService.getByConditions({
            type: 3,
            level: '2',
            pid: pid,
            from: userId,
            status: 1
        }, function(err, thread) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                var rs = {};
                rs.data = thread;
                res.json(_.assign(rs, returnCode.SUCCESS));
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//更新文章状态、如：屏蔽
router.post('/thread/:tid/update', function(req, res, next) {
    var tid = req.params.tid;
    if (tid) {
        forumThreadService.updateThreadById(tid, req.body, function(err, thread) {
            if (err) {
                res.json(returnCode.BUSY);
            } else {
                if (!isNaN(req.body.status)) {
                    forumAboutMEService.updateThreadStatus(thread._id, thread.status)
                }
                res.json(returnCode.SUCCESS);
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//删除文章
router.post('/thread/:tid/delete', function(req, res, next) {
    var tid = req.params.tid;
    if (tid) {
        //注销此方法

        // forumThreadService.deleteThreadById(tid, function(err, thread) {
        //     if (err) {
        //         res.json(returnCode.BUSY);
        //     } else {
        //         res.json(returnCode.SUCCESS);
        //     }
        // });
        res.json(returnCode.BUSY);
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//文章点赞和取消点赞
router.post('/thread/:tid/praiseOrCancelPraise', function(req, res, next) {
    var userId = user.getMobileUser(req);
    var mid = req.session.openUser.mid;
    var tid = req.params.tid || null;
    var ent_code = req.session.user.ent_code;
    if (tid) {
        raiseOrcancelRaise(req, ent_code, tid, userId,function(result){
            res.json(result);
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//文章分享
router.post('/thread/:tid/share', function(req, res, next) {
    var tid = req.params.tid || null;
    if (tid) {
        var integral = req.session.openUser.integral || 0;
        var exp = req.session.openUser.exp || 0;
        var destination = req.body.destination || '1';
        //1.检查是否有权限
        forumRolePermissionService.checkRolePermiss(req.session.user.ent_code, 'share', integral, exp, function(err, result) {
            if (err) {
                res.json(returnCode.BUSY);
            } else {
                if (result) { //有操作权限
                    //2.获取论坛文章
                    forumThreadService.getThreadById(tid, function(err, thread) {
                        if (err) {
                            res.json(returnCode.BUSY);
                        } else {
                            async.parallel([
                                function(callback) {
                                    //3.更新文章统计数据(分享数)
                                    if (thread) {
                                        forumThreadService.updateThreadShareCount(tid, function(err, cb) {
                                            if (err) {
                                                callback(err, null);
                                            } else {
                                                callback(null, null);
                                            }
                                        });
                                    } else {
                                        callback('cannot find thread by id', null);
                                    }
                                },
                                function(callback) {
                                    var entity = {
                                        ent_code: req.session.user.ent_code,
                                        user: user.getMobileUser(req),
                                        thread: tid,
                                        destination: destination,
                                        ip: req.ip
                                    };
                                    //4.创建分享日志
                                    forumShareLogService.createShareLog(entity, function(err, result) {
                                        if (err) {
                                            callback(err, null);
                                        } else {
                                            callback(null, null);
                                        }
                                    });
                                }
                            ], function(err, results) {
                                if (err) {
                                    console.error(err);
                                    res.json(returnCode.BUSY);
                                } else {
                                    // httpService.sendRequest(req.session.user.ent_code,req.session.openUser.mid,'share');
                                    res.json(returnCode.SUCCESS);
                                }
                            });
                        }
                    });
                } else {
                    res.json(returnCode.ACTION_NOT_PERMISSION);
                }
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//新增文章评论
router.post('/thread/:tid/comment/add', function(req, res, next) {
    var userId = req.session.mobileForumUser.userId;
    forumLimitOperationService.checkLimitOperationProhibitionOfSpeech(userId, function(err, isProhibition) {
        if (err) {
            console.error(err);
            res.json(returnCode.PROHIBITION_OF_SPEECH);
        } else {
            if (isProhibition) {
                res.json(returnCode.PROHIBITION_OF_SPEECH);
            } else {
                var tid = req.params.tid || null;
                if (tid) {
                    var integral = req.session.openUser.integral || 0;
                    var exp = req.session.openUser.exp || 0;
                    var destination = req.body.destination || '1';
                    //1.检查是否有权限
                    // forumRolePermissionService.checkRolePermiss(req.session.user.ent_code, 'comment', integral, exp, function(err, result) {
                    //     if (err) {
                    //         console.error(err);
                    //         res.json(returnCode.BUSY);
                    //     } else {
                    // if (result) { //有操作权限
                    var content = req.body.content;
                    if (content) { //评论不能为空
                        //2.获取论坛文章
                        forumThreadService.getThreadById(tid, function(err, thread) {
                            if (err) {
                                res.json(returnCode.BUSY);
                            } else {
                                async.parallel([
                                    function(callback) {
                                        var floor = 1;
                                        var entity = {
                                            ent_code: req.session.user.ent_code,
                                            from: user.getMobileUser(req),
                                            content: content,
                                            ip: req.ip,
                                            thread: thread,
                                            level: '1',
                                            floor: floor
                                        };

                                        floorGenerator.getCommentFloor(entity.ent_code,tid,function(err,floor){
                                            if (err) {
                                                callback(err,null);
                                            } else {
                                                entity.floor = floor;
                                                //4.创建文章评论
                                                forumCommentService.createComment(entity, function(err, newComment) {
                                                    if (err) {
                                                        callback(err, null);
                                                    } else {
                                                        try {
                                                            if (user.getMobileUser(req).toString() != thread.from._id.toString()) { //文章的作者不等于评论的作者才增加消息数
                                                                commentTips.incrTips(req.session.user.ent_code, thread.from._id);
                                                                forumThreadAttendService.threadAttend(thread._id, user.getMobileUser(req), function(err) {});
                                                            }
                                                        } catch (e) {
                                                            console.log(e);
                                                        }
                                                        forumAboutMEService.saveCommentLevel1(thread, newComment);
                                                        var comments = thread.comments;
                                                        var array = [];
                                                        if (comments && comments.items && comments.items.length > 0) {
                                                            array = comments.items;
                                                        }
                                                        array.push(newComment._id);
                                                        forumThreadService.updateThreadById(tid, {
                                                            comments: array
                                                        }, function(err, result) {
                                                            if (err) {
                                                                callback(err, newComment);
                                                            } else {
                                                                callback(null, newComment);
                                                            }
                                                        });
                                                    }
                                                });
                                            }
                                        });
                                    },
                                    function(callback) {
                                        //3.更新文章统计数据(评论数)
                                        if (thread) {
                                            forumThreadService.updateThreadCommentCountInc(tid, function(err, results) {
                                                if (err) {
                                                    callback(err, null);
                                                } else {
                                                    callback(null, null);
                                                }
                                            });
                                        } else {
                                            callback('cannot find thread by id', null);
                                        }
                                    }
                                ], function(err, results) {
                                    if (err) {
                                        console.error(err);
                                        res.json(returnCode.BUSY);
                                    } else {
                                        forumLimitOperationService.checkLimitOperationProhibitionAddIntegral(userId, function(err, flag) {
                                            if (err) {
                                                console.error(err);
                                            } else {
                                                if (!flag) {
                                                    httpService.sendRequest(req.session.user.ent_code, req.session.openUser.mid, 'comment');
                                                }
                                            }
                                        });
                                        forumCommentService.getPopulateCommentById(results[0]._id, function(err, c) {
                                            if (err) {
                                                res.json(returnCode.BUSY);
                                            } else {
                                                var rs = {};
                                                rs.data = c;
                                                loadUserLevel.loadLevelFromAPI(req.session.user.ent_code,rs.data.from.uid,function(err,expValue){
                                                        if(!err){
                                                                rs.data=rs.data.toObject();
                                                                if(!expValue)
                                                                    rs.data.from.exp=0;
                                                                else
                                                                    rs.data.from.exp=expValue[rs.data.from.uid];
                                                        }
                                                        res.json(_.assign(rs, returnCode.SUCCESS));
                                                });
                                            }
                                        });

                                    }
                                });
                            }
                        });
                    } else {
                        res.json(returnCode.WRONG_PARAM);
                    }
                } else {
                    res.json(returnCode.WRONG_PARAM);
                }
            }
        }
    });
});
//新增文章评论
router.post('/thread/:tid/comment/create', function(req, res, next) {
    var userId = req.session.mobileForumUser.userId;
    forumLimitOperationService.checkLimitOperationProhibitionOfSpeech(userId, function(err, isProhibition) {
        if (err) {
            console.error(err);
            res.json(returnCode.PROHIBITION_OF_SPEECH);
        } else {
            if (isProhibition) {
                res.json(returnCode.PROHIBITION_OF_SPEECH);
            } else {
                var tid = req.params.tid || null;
                if (tid) {
                    var integral = req.session.openUser.integral || 0;
                    var exp = req.session.openUser.exp || 0;
                    var destination = req.body.destination || '1';
                    //1.检查是否有权限
                    forumRolePermissionService.checkRolePermiss(req.session.user.ent_code, 'comment', integral, exp, function(err, result) {
                        if (err) {
                            console.error(err);
                            res.json(returnCode.BUSY);
                        } else {
                            if (result) { //有操作权限
                                var content = req.body.content;
                                if (content) { //评论不能为空
                                    var temp_content = content;
                                    temp_content = temp_content.replace(/<img\/?.+?border="0">/g,"");
                                    if(temp_content.length > 500){ //超出500字数
                                        res.json(returnCode.COMTENT_OVERSTEP);
                                    }else{
                                        //2.获取论坛文章
                                        forumThreadService.getThreadById(tid, function(err, thread) {
                                            if (err) {
                                                res.json(returnCode.BUSY);
                                            } else {
                                                async.parallel([
                                                    function(callback) {
                                                        var floor = 1;
                                                        var entity = {
                                                            ent_code: req.session.user.ent_code,
                                                            from: user.getMobileUser(req),
                                                            content: content,
                                                            ip: req.ip,
                                                            thread: thread,
                                                            level: '1',
                                                            floor: floor
                                                        };

                                                        floorGenerator.getCommentFloor(entity.ent_code,tid,function(err,floor){
                                                            if (err) {
                                                                callback(err);
                                                            } else {
                                                                entity.floor = floor;
                                                                //4.创建文章评论
                                                                forumCommentService.createComment(entity, function(err, newComment) {
                                                                    if (err) {
                                                                        callback(err, null);
                                                                    } else {
                                                                        try {
                                                                            if (user.getMobileUser(req).toString() != thread.from._id.toString()) { //文章的作者不等于评论的作者才增加消息数
                                                                                commentTips.incrTips(req.session.user.ent_code, thread.from._id);
                                                                                forumThreadAttendService.threadAttend(thread._id, user.getMobileUser(req), function(err) {});
                                                                            }
                                                                        } catch (e) {
                                                                            console.log(e);
                                                                        }

                                                                        forumAboutMEService.saveCommentLevel1(thread, newComment);
                                                                        var comments = thread.comments;
                                                                        var array = [];
                                                                        if (comments && comments.items && comments.items.length > 0) {
                                                                            array = comments.items;
                                                                        }
                                                                        array.push(newComment._id);
                                                                        forumThreadService.updateThreadById(tid, {
                                                                            comments: array
                                                                        }, function(err, result) {
                                                                            if (err) {
                                                                                callback(err, null);
                                                                            } else {
                                                                                callback(null, null);
                                                                            }
                                                                        });
                                                                    }
                                                                });
                                                            }
                                                        });
                                                    },
                                                    function(callback) {
                                                        //3.更新文章统计数据(评论数)
                                                        if (thread) {
                                                            forumThreadService.updateThreadCommentCountInc(tid, function(err, results) {
                                                                if (err) {
                                                                    console.log(err);
                                                                    callback(err, null);
                                                                } else {
                                                                    callback(null, null);
                                                                }
                                                            });
                                                        } else {
                                                            callback('cannot find thread by id', null);
                                                        }
                                                    }
                                                ], function(err, results) {
                                                    if (err) {
                                                        console.error(err);
                                                        res.json(returnCode.BUSY);
                                                    } else {
                                                        forumLimitOperationService.checkLimitOperationProhibitionAddIntegral(userId, function(err, flag) {
                                                            if (err) {
                                                                console.error(err);
                                                            } else {
                                                                if (!flag) {
                                                                    httpService.sendRequest(req.session.user.ent_code, req.session.openUser.mid, 'comment');
                                                                }
                                                            }
                                                        });

                                                        async.parallel([
                                                            function(callback) {
                                                                //获取最新5条评论
                                                                var conditions = {
                                                                    thread: tid,
                                                                    level: '1'
                                                                };
                                                                forumCommentService.getAllComment(conditions, 1, 5, function(err, results) {
                                                                    if (err) {
                                                                        console.log(err);
                                                                        callback(err, null);
                                                                    } else {
                                                                        callback(null, results);
                                                                    }
                                                                });
                                                            },
                                                            function(callback) {
                                                                forumThreadService.getThreadById(tid, function(err, thread) {
                                                                    if (err) {
                                                                        console.log(err);
                                                                        callback(err, null);
                                                                    } else {
                                                                        callback(null, thread);
                                                                    }
                                                                });
                                                            }
                                                        ], function(err, results) {
                                                            if (err) {
                                                                res.json(returnCode.BUSY);
                                                            } else {
                                                                var rs = {};
                                                                rs.comments = results[0].items;
                                                                rs.commentCount = results[1].comment_count;
                                                                res.json(_.assign(rs, returnCode.SUCCESS));
                                                            }
                                                        });

                                                    }
                                                });
                                            }
                                        });
                                    }
                                } else {
                                    res.json(returnCode.WRONG_PARAM);
                                }
                            } else {
                                res.json(returnCode.ACTION_NOT_PERMISSION);
                            }
                        }
                    });
                } else {
                    res.json(returnCode.WRONG_PARAM);
                }
            }
        }
    });
});
//新建文章评论的子评论
router.post('/thread/:tid/comment/:cid/create', function(req, res, next) {
    var userId = req.session.mobileForumUser.userId;
    forumLimitOperationService.checkLimitOperationProhibitionOfSpeech(userId, function(err, isProhibition) {
        if (err) {
            console.error(err);
            res.json(returnCode.PROHIBITION_OF_SPEECH);
        } else {
            if (isProhibition) {
                res.json(returnCode.PROHIBITION_OF_SPEECH);
            } else {
                var tid = req.params.tid || null;
                var cid = req.params.cid || null;
                if (tid && cid) {
                    var integral = req.session.openUser.integral || 0;
                    var exp = req.session.openUser.exp || 0;
                    var destination = req.body.destination || '1';
                    req.body.from = user.getMobileUser(req);

                    //1.检查是否有权限
                    forumRolePermissionService.checkRolePermiss(req.session.user.ent_code, 'reply', integral, exp, function(err, result) {
                        if (err) {
                            console.error(err);
                            res.json(returnCode.BUSY);
                        } else {
                            if (result) { //有操作权限
                                var content = req.body.content;
                                if (content) { //评论不能为空
                                    //2.获取论坛评论
                                    forumCommentService.getCommentById(cid, function(err, comment) {
                                        if (err) {
                                            res.json(returnCode.BUSY);
                                        } else {
                                            async.parallel([
                                                function(callback) {
                                                    var entity = {
                                                        ent_code: req.session.user.ent_code,
                                                        from: user.getMobileUser(req),
                                                        to: req.body.to,
                                                        content: content,
                                                        ip: req.ip,
                                                        thread: tid,
                                                        level: '2'
                                                    };
                                                    //4.创建文章评论
                                                    forumCommentService.createComment(entity, function(err, newComment) {
                                                        if (err) {
                                                            callback(err, null);
                                                        } else {
                                                            try {
                                                                if (user.getMobileUser(req).toString() != req.body.to.toString()) { //被评论人 和评论人不是同一个
                                                                    commentTips.incrTips(req.session.user.ent_code, req.body.to);
                                                                    forumThreadAttendService.threadAttend(tid, user.getMobileUser(req), function(err) {});
                                                                }
                                                            } catch (e) {
                                                                console.log(e);
                                                            }
                                                            forumAboutMEService.saveCommentLevel2(tid, comment, newComment);
                                                            var comments = comment.comments;
                                                            var array = [];
                                                            if (comments && comments.length > 0) {
                                                                array = comments;
                                                            }
                                                            array.push(newComment._id);
                                                            forumCommentService.updateCommentById(cid, {
                                                                comments: array
                                                            }, function(err, result) {
                                                                if (err) {
                                                                    callback(err, null);
                                                                } else {
                                                                    callback(null, newComment);
                                                                }
                                                            });
                                                        }
                                                    });
                                                },
                                                function(callback) {
                                                    forumCommentService.updateCommentCount(cid, function(err, results) {
                                                        if (err) {
                                                            console.log(err);
                                                            callback(err, null);
                                                        } else {
                                                            callback(null, null);
                                                        }
                                                    });
                                                }
                                            ], function(err, results) {
                                                if (err) {
                                                    console.error(err);
                                                    res.json(returnCode.BUSY);
                                                } else {
                                                    forumLimitOperationService.checkLimitOperationProhibitionAddIntegral(userId, function(err, flag) {
                                                        if (err) {
                                                            console.error(err);
                                                        } else {
                                                            if (!flag) {
                                                                httpService.sendRequest(req.session.user.ent_code, req.session.openUser.mid, 'reply');
                                                            }
                                                        }
                                                    });
                                                    forumCommentService.getPopulateCommentById(results[0]._id, function(err, c) {
                                                        if (err) {
                                                            res.json(returnCode.BUSY);
                                                        } else {

                                                            var rs = {};
                                                            rs.data = c;
                                                            res.json(_.assign(rs, returnCode.SUCCESS));
                                                        }
                                                    });
                                                }
                                            });
                                        }
                                    });
                                } else {
                                    res.json(returnCode.WRONG_PARAM);
                                }
                            } else {
                                res.json(returnCode.ACTION_NOT_PERMISSION);
                            }
                        }
                    });
                } else {
                    res.json(returnCode.WRONG_PARAM);
                }
            }
        }
    });
});
//更改评论状态为2(删除)
router.post('/thread/:tid/comment/:cid/disable', function(req, res, next) {
    var user_id = user.getMobileUser(req),
        tid = req.params.tid,
        cid = req.params.cid;
    if (tid && cid) {
        forumCommentService.getCommentById(cid, function(err, comment) {
            if (comment && user_id) {
                if (comment.from.toString() == user_id.toString()) {
                    forumCommentService.changeStatus(cid, 2, function(err, update) {
                        if (err) {
                            res.json(returnCode.BUSY);
                        } else {
                            if (comment && comment.level == 1) {
                                forumAboutMEService.updateCommentLevel1Status(comment._id, 2);
                            }
                            if (comment && comment.level == 2) {
                                forumAboutMEService.updateCommentLevel2Status(comment._id, 2);
                            }
                            res.json(returnCode.SUCCESS);
                        }
                    });
                } else {
                    res.json(returnCode.ACTION_NOT_PERMISSION);
                }
            } else {
                res.json(returnCode.WRONG_PARAM);
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//更改评论状态为0(屏蔽)
router.post('/thread/:tid/comment/:cid/slash', function(req, res, next) {
    var tid = req.params.tid,
        entCode = req.session.user.ent_code,
        userid = user.getMobileUser(req),//user._id 
        cid = req.params.cid;
    var q1={};//拼装查询条件
    q1.ent_code = entCode;
    q1._id=tid;
    q1.status=1;
    q1.$or=[{
        recommend: 0
    },{
        recommend: 1
    }, {
        recommend: null
    }];

    async.waterfall([
        function(callback) {
            forumThreadService.getByConditions(q1, function(err, doc) {  //查询文章
                if (err || !doc || !doc.info) {
                    callback(err, null);
                } else {
                    callback(null, doc);
                }
            });
        },
        function(thread, callback) {
            var q2 = {};//查询当前用户是不是这篇文章的版主
            q2.status=1;
            q2.ent_code = entCode;
            q2.forumUser=userid;
            q2.infoIds={$all:[thread.info]};
            forumModeratorApplyService.getForumModeratorApplyByConditions(q2, function(err, doc) {
                if (err) {
                    callback(err, null);
                } else {
                    callback(null, doc);
                }
            });
        },
        function(forumModerator, callback) {  //查询评论
            forumCommentService.getCommentById(cid, function(err, comment) {
                if (err) {
                    callback(err, null, null);
                } else {
                    callback(null, forumModerator, comment);
                }
            });
        }
    ], function(err, forumModerator, comment) {
        if(err){
            res.json(returnCode.BUSY);
        } else if(forumModerator && comment){ //版主屏蔽
            forumCommentService.changeStatus(cid, 0, function(err, update) {
                if (err) {
                    res.json(returnCode.BUSY);
                } else {
                    if (comment && comment.level == 1) {
                        forumAboutMEService.updateCommentLevel1Status(comment._id, 0);
                    }
                    res.json(returnCode.SUCCESS);
                }
            });
        }else if(comment && userid){ //用户自己屏蔽
            if (comment.from.toString() == userid.toString()) {
                forumCommentService.changeStatus(cid, 0, function(err, update) {
                    if (err) {
                        res.json(returnCode.BUSY);
                    } else {
                        if (comment && comment.level == 1) {
                            forumAboutMEService.updateCommentLevel1Status(comment._id, 2);
                        }
                        if (comment && comment.level == 2) {
                            forumAboutMEService.updateCommentLevel2Status(comment._id, 2);
                        }
                        res.json(returnCode.SUCCESS);
                    }
                });
            } else {
                res.json(returnCode.ACTION_NOT_PERMISSION);
            }
        }else{
            res.json(returnCode.BUSY);
        }
    });
});

//删除文章评论
router.post('/thread/:tid/comment/:cid/delete', function(req, res, next) {
    var tid = req.params.tid || null;
    var cid = req.params.cid || null;
    if (tid && cid) {
        forumCommentService.getCommentById(cid, function(err, result) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                if (result) {
                    if (result.from === user.getMobileUser(req)) {
                        async.parallel([
                            function(callback) {
                                forumCommentService.deleteCommentById(cid, function(err, result) {
                                    if (err) {
                                        callback(err, null);
                                    } else {
                                        callback(null, null);
                                    }
                                });
                            }
                        ], function(err, results) {
                            if (err) {
                                res.json(returnCode.BUSY);
                            } else {
                                res.json(returnCode.SUCCESS);
                            }
                        });

                    } else {
                        res.json(returnCode.ACTION_NOT_PERMISSION);
                    }
                } else {
                    res.json(returnCode.WRONG_PARAM);
                }
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//评论列表
router.get('/thread/:tid/comment/list', function(req, res, next) {

    var tid = req.params.tid || null;
    var pageNo = req.query.pageNo || 1;
    var tid = req.params.tid || null;
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var ent_code = req.session.user.ent_code;
    var conditions = {
        ent_code: ent_code,
        thread: tid,
        level: '1'
    };

    if (tid) {
        //获取最新5条评论                                          
        forumCommentService.getAllComment(conditions, pageNo, pageSize, function(err, results) {
            if (err) {
                console.log(err);
                res.json(returnCode.BUSY);
            } else {
                //判断是否已经点赞
                util.loadLevel(req.session.user.ent_code, results.items, function() {
                    redisPraiseLog.get(ent_code, user.getMobileUser(req), 'comment', function(error, docs) {
                        _.forEach(results.items, function(d, i) {
                            if (results.items[i].toObject) {
                                results.items[i] = results.items[i].toObject();
                            }
                            results.items[i].isPraise = false;
                            for (var k = docs.length - 1; k >= 0; k--) {
                                if (results.items[i]._id == docs[k]) {
                                    results.items[i].isPraise = true;
                                    break;
                                }
                            };
                        });
                        res.json(_.assign(results, returnCode.SUCCESS));
                    });
                });
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

router.get('/thread/:tid/comment/list/byFloor', function(req, res, next) {

    var tid = req.params.tid || null;
    var floor = req.query.floor || 1;
    var ent_code = req.session.user.ent_code;

    var countConditions = {
        ent_code: ent_code,
        thread: tid,
        level: '1'
    };

    var conditions = {
        ent_code: ent_code,
        thread: tid,
        level: '1',
        floor: {
            '$gte': floor - 9,
            '$lte': floor
        }
    };

    if (tid) {
        //获取最新5条评论              
        forumCommentService.count(countConditions, function(err, count) {
            if (err) {
                console.log(err);
                res.json(returnCode.BUSY);
            } else {
                forumCommentService.getAllComment(conditions, 1, 10, function(err, results) {
                    if (err) {
                        console.log(err);
                        res.json(returnCode.BUSY);
                    } else {
                        //判断是否已经点赞
                        util.loadLevel(req.session.user.ent_code, results.items, function() {
                            redisPraiseLog.get(ent_code, user.getMobileUser(req), 'comment', function(error, docs) {
                                _.forEach(results.items, function(d, i) {
                                    if (results.items[i].toObject) {
                                        results.items[i] = results.items[i].toObject();
                                    }
                                    results.items[i].isPraise = false;
                                    for (var k = docs.length - 1; k >= 0; k--) {
                                        if (results.items[i]._id == docs[k]) {
                                            results.items[i].isPraise = true;
                                            break;
                                        }
                                    };
                                });
                                results.total = count;
                                res.json(_.assign(results, returnCode.SUCCESS));
                            });
                        });
                    }
                });
            }

        });

    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//不过滤掉已删除的二级评论
router.get('/thread/:tid/comment/list/all', function(req, res, next) {

    var tid = req.params.tid || null;
    var pageNo = req.query.pageNo || 1;
    var tid = req.params.tid || null;
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var ent_code = req.session.user.ent_code;
    var conditions = {
        ent_code: ent_code,
        thread: tid,
        level: '1'
    };

    if (tid) {
        //获取最新5条评论
        forumCommentService.getAllComment_allstatus(conditions, pageNo, pageSize, function(err, results) {
            if (err) {
                console.log(err);
                res.json(returnCode.BUSY);
            } else {
                //判断是否已经点赞
                util.loadLevel(req.session.user.ent_code, results.items, function() {
                    redisPraiseLog.get(ent_code, user.getMobileUser(req), 'comment', function(error, docs) {
                        _.forEach(results.items, function(d, i) {
                            if (results.items[i].toObject) {
                                results.items[i] = results.items[i].toObject();
                            }
                            results.items[i].isPraise = false;
                            for (var k = docs.length - 1; k >= 0; k--) {
                                if (results.items[i]._id == docs[k]) {
                                    results.items[i].isPraise = true;
                                    break;
                                }
                            };
                        });
                        res.json(_.assign(results, returnCode.SUCCESS));
                    });
                });
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

router.get('/thread/:tid/comment/list/allV2', function(req, res, next) {

    var tid = req.params.tid || null;
    var pageNo = req.query.pageNo || 1;
    var tid = req.params.tid || null;
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var ent_code = req.session.user.ent_code;
    var conditions = {
        ent_code: ent_code,
        thread: tid,
        level: '1'
    };
    if (tid) {
        //获取最新5条评论
        forumCommentService.getAllComment_allstatus_v2(conditions, pageNo, pageSize, function(err, results) {
            if (err) {
                console.log(err);
                res.json(returnCode.BUSY);
            } else {
                //判断是否已经点赞
                util.loadLevel(req.session.user.ent_code, results.items, function() {
                    redisPraiseLog.get(ent_code, user.getMobileUser(req), 'comment', function(error, docs) {
                        _.forEach(results.items, function(d, i) {
                            if (results.items[i].toObject) {
                                results.items[i] = results.items[i].toObject();
                            }
                            results.items[i].isPraise = false;
                            for (var k = docs.length - 1; k >= 0; k--) {
                                if (results.items[i]._id == docs[k]) {
                                    results.items[i].isPraise = true;
                                    break;
                                }
                            };
                        });
                        res.json(_.assign(results, returnCode.SUCCESS));
                    });
                });
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//不过滤掉已删除的二级评论
router.get('/thread/:tid/comment/list/byFloor/all', function(req, res, next) {

    var tid = req.params.tid || null;
    var floor = req.query.floor || 1;
    var ent_code = req.session.user.ent_code;

    var countConditions = {
        ent_code: ent_code,
        thread: tid,
        level: '1'
    };

    var conditions = {
        ent_code: ent_code,
        thread: tid,
        level: '1',
        floor: {
            '$gte': floor - 9,
            '$lte': floor
        }
    };

    if (tid) {
        //获取最新5条评论
        forumCommentService.count(countConditions, function(err, count) {
            if (err) {
                console.log(err);
                res.json(returnCode.BUSY);
            } else {
                forumCommentService.getAllComment_allstatus(conditions, 1, 10, function(err, results) {
                    if (err) {
                        console.log(err);
                        res.json(returnCode.BUSY);
                    } else {
                        //判断是否已经点赞
                        util.loadLevel(req.session.user.ent_code, results.items, function() {
                            redisPraiseLog.get(ent_code, user.getMobileUser(req), 'comment', function(error, docs) {
                                _.forEach(results.items, function(d, i) {
                                    if (results.items[i].toObject) {
                                        results.items[i] = results.items[i].toObject();
                                    }
                                    results.items[i].isPraise = false;
                                    for (var k = docs.length - 1; k >= 0; k--) {
                                        if (results.items[i]._id == docs[k]) {
                                            results.items[i].isPraise = true;
                                            break;
                                        }
                                    };
                                });
                                results.total = count;
                                res.json(_.assign(results, returnCode.SUCCESS));
                            });
                        });
                    }
                });
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});
//评论点赞
router.post('/thread/:tid/comment/:cid/raise', function(req, res, next) {
    var userId = req.session.mobileForumUser.userId;
    var tid = req.params.tid || null;
    var cid = req.params.cid || null;
    var mid = req.session.openUser.mid;
    var ent_code = req.session.user.ent_code;
    if (tid && cid) {
        conmentRaiseOrcancelRaise(req, ent_code, tid, cid, userId, function(result){
            res.json(result);
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//评论取消点赞
router.post('/thread/:tid/comment/:cid/cancelRaise', function(req, res, next) {
    var userId = req.session.mobileForumUser.userId;
    var tid = req.params.tid || null;
    var cid = req.params.cid || null;
    var mid = req.session.openUser.mid;
    var ent_code = req.session.user.ent_code;
    if (tid && cid) {
        conmentRaiseOrcancelRaise(req, ent_code, tid, cid, userId,function(result){
            res.json(result);
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//评论点赞和取消点赞
router.post('/thread/:tid/comment/:cid/praiseOrCancelPraise', function(req, res, next) {
    var userId = user.getMobileUser(req);
    var tid = req.params.tid || null;
    var cid = req.params.cid || null;
    var mid = req.session.openUser.mid;
    var ent_code = req.session.user.ent_code;
    if (tid && cid) {
        conmentRaiseOrcancelRaise(req, ent_code, tid, cid, userId, function(result){
            res.json(result);
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//用户屏蔽文章
router.post('/thread/:tid/userShield', function(req, res, next) {
    var tid = req.params.tid || null;
    if (tid) {
        forumUserThreadControlService.getUserThreadControlById(user.getMobileUser(req), function(err, doc) {
            if (err) {
                res.json(returnCode.BUSY);
            } else {
                if (doc) {
                    var thread = doc.thread;
                    thread.push(tid);
                    forumUserThreadControlService.updateUserThreadControlById(doc._id, {
                        thread: thread
                    }, function(err, result) {
                        if (err) {
                            res.json(returnCode.BUSY);
                        } else {
                            res.json(returnCode.SUCCESS);
                        }
                    });
                } else {
                    var array = [tid];
                    var entity = {
                        ent_code: req.session.user.ent_code,
                        user: user.getMobileUser(req),
                        thread: array
                    };
                    forumUserThreadControlService.createUserThreadControl(entity, function(err, result) {
                        if (err) {
                            res.json(returnCode.BUSY);
                        } else {
                            res.json(returnCode.SUCCESS);
                        }
                    });
                }
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//获取论坛话题列表
router.get('/thread/:tid/topics', function(req, res, next) {
    var tid = req.params.tid || null;
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;

    var conditions = {
        ent_code: req.session.user.ent_code,
        pid: tid,
        // type: 2,
        status: 1
    };
    if (tid) {
        async.waterfall([
            function(callback) {
                forumUserThreadControlService.getUserThreadControlById(user.getMobileUser(req), function(err, doc) {
                    if (err) {
                        callback(err, null);
                    } else {
                        if (doc) {
                            callback(null, doc);
                        } else {
                            callback(null, null);
                        }
                    }
                });
            }
        ], function(err, result) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                if (result) {
                    conditions._id = {
                        $nin: result.thread
                    };
                }
                //获取子话题数据
                forumThreadService.getAllThreadByFid(conditions, pageNo, pageSize, null, function(err, results) {
                    if (err) {
                        console.error(err);
                        res.json(returnCode.BUSY);
                    } else {
                        res.json(_.assign(results, returnCode.SUCCESS));
                    }
                });
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//获取论坛最新照片墙列表
router.get('/thread/:tid/latestPhotos', function(req, res, next) {
    var tid = req.params.tid || null;
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var ent_code = req.session.user.ent_code;
    var conditions = {
        ent_code: ent_code,
        pid: tid,
        // type: 3,
        status: 1,
        images: {
            $exists: true,
            $not: {
                $size: 0
            }
        }
    };

    if (tid) {
        async.waterfall([
            function(callback) {
                forumUserThreadControlService.getUserThreadControlById(user.getMobileUser(req), function(err, doc) {
                    if (err) {
                        callback(err, null);
                    } else {
                        if (doc) {
                            callback(null, doc);
                        } else {
                            callback(null, null);
                        }
                    }
                });
            }
        ], function(err, result) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                if (result) {
                    conditions._id = {
                        $nin: result.thread
                    };
                }
                //获取子话题数据
                forumThreadService.getAllThreadByFid(conditions, pageNo, pageSize, '-quality -created', function(err, results) {
                    if (err) {
                        console.error(err);
                        res.json(returnCode.BUSY);
                    } else {
                        redisPraiseLog.get(ent_code, user.getMobileUser(req), 'thread', function(error, docs) {
                            _.forEach(results.items, function(d, i) {
                                if (results.items[i].toObject) {
                                    results.items[i] = results.items[i].toObject();
                                }
                                results.items[i].isPraise = false;
                                for (var k = docs.length - 1; k >= 0; k--) {
                                    if (results.items[i]._id == docs[k]) {
                                        results.items[i].isPraise = true;
                                        break;
                                    }
                                };
                            });
                            res.json(_.assign(results, returnCode.SUCCESS));
                        });
                    }
                });
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//获取论坛最热照片墙列表
router.get('/thread/:tid/hotPhotos', function(req, res, next) {
    var tid = req.params.tid || null;
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var ent_code = req.session.user.ent_code;
    var conditions = {
        ent_code: ent_code,
        pid: tid,
        // type: 3,
        status: 1,
        images: {
            $exists: true,
            $not: {
                $size: 0
            }
        }
    };

    if (tid) {
        async.waterfall([
            function(callback) {
                forumUserThreadControlService.getUserThreadControlById(user.getMobileUser(req), function(err, doc) {
                    if (err) {
                        callback(err, null);
                    } else {
                        if (doc) {
                            callback(null, doc);
                        } else {
                            callback(null, null);
                        }
                    }
                });
            }
        ], function(err, result) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                if (result) {
                    conditions._id = {
                        $nin: result.thread
                    };
                }
                //获取子话题数据
                forumThreadService.getAllThreadByFid(conditions, pageNo, pageSize, '-praise_count', function(err, results) {
                    if (err) {
                        console.error(err);
                        res.json(returnCode.BUSY);
                    } else {
                        redisPraiseLog.get(ent_code, user.getMobileUser(req), 'thread', function(error, docs) {
                            _.forEach(results.items, function(d, i) {
                                if (results.items[i].toObject) {
                                    results.items[i] = results.items[i].toObject();
                                }
                                results.items[i].isPraise = false;
                                for (var k = docs.length - 1; k >= 0; k--) {
                                    if (results.items[i]._id == docs[k]) {
                                        results.items[i].isPraise = true;
                                        break;
                                    }
                                };
                            });
                            res.json(_.assign(results, returnCode.SUCCESS));
                        });
                    }
                });
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});


//屏蔽文章
router.post('/thread/:tid/disable', function(req, res, next) {
    var user_id = user.getMobileUser(req);
    var tid = req.params.tid;
    if (tid) {
        forumThreadService.getThreadById(tid, function(err, thread) {
            if (thread.from && user_id) {
                if (thread.from._id.toString() == user_id.toString()) {
                    forumThreadService.updateThreadById_2(tid, {status : 0},function(err, flag) {
                        if (err) {
                            res.json(returnCode.BUSY);
                        } else {
                            forumAboutMEService.updateThreadStatus(tid, 0);
                            res.json(returnCode.SUCCESS);
                        }
                    });
                } else {
                    res.json(returnCode.ACTION_NOT_PERMISSION);
                }
            } else {
                res.json(returnCode.WRONG_PARAM);
            }
        })
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//查询帖子列表数据,不获取评论,话题获取参与用
router.get('/thread/getThreadWithNotPopulateComment', function(req, res, next) {
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var infoId = req.query.infoId || null;
    var tagId = req.query.tagId || null;
    var sort = '-_id';
    var ent_code = req.session.user.ent_code;
    var today = new Date();
    var conditions = {
        ent_code: ent_code,
        level: 1,
        status: 1,
        $or: [{
            isEvent: {
                $ne:1
            }
        }, {
            isEvent: 1,
            'event.eventStartTime' : {$lte : today}
        }]
    };
    if(infoId){
        conditions.info = infoId;
    }
    if(tagId){
        conditions.tag={$in:[tagId]};
    }
    queryThread(conditions, pageNo, pageSize, sort, function(err, results){
        if(err){
            console.error(err);
            res.json(returnCode.BUSY);
        }else{
            util.loadLevel(ent_code, results.items, function() {
                handleThreadList(req, results, ent_code, function(result){
                    res.json(_.assign(result, returnCode.SUCCESS));
                });
            });
        }
    });
});


//获取推荐文章
router.get('/thread/getThreadWithEssence', function(req, res, next) {
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var infoId = req.query.infoId || null;
    var ent_code = req.session.user.ent_code;
    var skip = (pageNo - 1) * pageSize;
    var sort = {
        new_recommend:-1,
        new_recommend_order_idx:-1,
        new_recommend_time:-1,
        top:-1,
        top_order_idx:-1,
        topTime:-1,
        tag_top:-1,
        tag_topTime:-1,
        quality:-1,
        created:-1
    };
    var today = new Date();
    var conditions = {
        ent_code: ent_code,
        level: 1,
        status: 1,
        new_recommend: 1,
        $or: [{
            isEvent: {
                $ne:1
            }
        }, {
            isEvent: 1,
            'event.eventStartTime' : {$lte : today}
        }]
    };

    if((pageNo * pageSize) > redisThreadList.getThreadRedisCount() || infoId){
        if(infoId){
            conditions.info = infoId;
        }
        queryThread(conditions, pageNo, pageSize, sort, function(err, results){
            if(err){
                console.error(err);
                res.json(returnCode.BUSY);
            }else{
                util.loadLevel(ent_code, results.items, function() {
                    handleThreadList(req, results, ent_code, function(result){
                        res.json(_.assign(result, returnCode.SUCCESS));
                    });
                });
            }
        });
    }else{
        //更新推荐列表redis
        redisThreadList.get(ent_code, function(error, docs) {
            var results = JSON.parse(docs);
            if(results.items == null || results.items.length <= 0){ //如果不存在，继续重新获取
                redisThreadList.getRedisEsenceThreads(ent_code, function(error, docs){
                    if(error){
                        console.error(err);
                        res.json(returnCode.BUSY);
                    }else{
                        docs = JSON.parse(docs);
                        docs.items =  docs.items.slice(skip, skip+pageSize);
                        handleThreadList(req, docs, ent_code, function(result){
                            res.json(_.assign(result, returnCode.SUCCESS));
                        });
                    }
                });
            }else{  //只取缓存里面
                results.items =  results.items.slice(skip, Number(skip) + Number(pageSize));
                handleThreadList(req, results, ent_code, function(result){
                    res.json(_.assign(result, returnCode.SUCCESS));
                });
            }
        });
    }
});

//查询帖子
function queryThread(conditions, pageNo, pageSize, sort,callback){
    forumThreadService.getThreadWithNotPopulateComment(conditions, pageNo, pageSize, sort, function(err, results) {
        callback(err, results);
    });
}

//处理帖子
function handleThreadList(req, results, ent_code, callback){
    var today = new Date();
    redisPraiseLog.get(ent_code, user.getMobileUser(req), 'thread', function(error, docs) {
        _.forEach(results.items, function(d, i) {
            if (results.items[i].toObject) {
                results.items[i] = results.items[i].toObject();
            }

            //设置帖子的活动
            if(results.items[i].isEvent && results.items[i].isEvent == 1){
                if(new Date(results.items[i].event.eventEndTime) < today){
                    results.items[i].eventStatus = 2; //'已结束';
                }else{
                    results.items[i].eventStatus = 1; //'进行中';
                }
            }

            results.items[i].isPraise = false;
            for (var k = docs.length - 1; k >= 0; k--) {
                if (results.items[i]._id == docs[k]) {
                    results.items[i].isPraise = true;
                    break;
                }
            };
        });
        callback(results);
    });
}


//新圈子首页帖子列表 最热
router.get('/thread/getThreadWithNotPopulateComment/hot', function(req, res, next) {
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var infoId = req.query.infoId || null;
    var tagId = req.query.tagId || null;
    var sort = '-top -top_order_idx -quality -_id';
    var ent_code = req.session.user.ent_code;
    var today = new Date();
    var conditions = {
        ent_code: ent_code,
        level: 1,
        status: 1,
        $or: [{
            isEvent: {
                $ne:1
            }
        }, {
            isEvent: 1,
            'event.eventStartTime' : {$lte : today}
        }]
    };
    if(infoId){
        conditions.info = infoId;
    }
    if(tagId){
        sort = "-tag_top -quality -_id";
        conditions.tag={$in:[tagId]};
    }
    queryThread(conditions, pageNo, pageSize, sort, function(err, results){
        if(err){
            console.error(err);
            res.json(returnCode.BUSY);
        }else{
            util.loadLevel(ent_code, results.items, function() {
                handleThreadList(req, results, ent_code, function(result){
                    res.json(_.assign(result, returnCode.SUCCESS));
                });
            });
        }
    });
});


//获取话题下子文章
router.get('/thread/:tid/get/subThreads/:type', function(req, res, next) {
    var tid = req.params.tid || null;
    var type = req.params.type || null;
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var ent_code = req.session.user.ent_code;
    var rs = {};
    var conditions = {
        ent_code: ent_code,
        pid: tid,
        // type: 2,
        status: 1
    };
    
    var sort = null;  //排序条件
    if(type == 1){   //最新
        sort = '-created';  
    }else if(type == 2){ //最热
        sort = '-praise_count -comment_count -created';
    }

    if (tid) {
        async.waterfall([
            function(callback) {
                forumThreadService.getByConditionsSelectyField({_id:tid}, 'type', function(err, thread) {
                    if (err) {
                        console.error(err);
                        callback(err, null);
                    } else {
                        callback(null, thread);
                    }
                });
            },
            function(thread, callback) {
                forumUserThreadControlService.getUserThreadControlById(user.getMobileUser(req), function(err, doc) {
                    if (err) {
                        console.error(err);
                        callback(err, null, null);
                    } else {
                        if (doc) {
                            callback(null, thread, doc);
                        } else {
                            callback(null, thread, null);
                        }
                    }
                });
            },
            function(thread, doc, callback) {
                if (thread.type == 2) { //查询子列表
                    if (doc) {
                        conditions._id = {
                            $nin: doc.thread
                        };
                    }
                    //获取子话题数据
                    forumThreadService.getThreadWithNotPopulateComment(conditions, pageNo, pageSize, sort, function(err, results) {
                        if (err) {
                            console.error(err);
                            callback(err, null);
                        } else {
                            callback(null, results);
                        }
                    });
                } else {
                    callback(null, null);
                }
            }
        ], function(err, results) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                if(results){
                    util.loadLevel(ent_code, results.items, function() {
                        handleThreadList(req, results, ent_code, function(result){
                            res.json(_.assign(result, returnCode.SUCCESS));
                        });
                    });
                }else{
                    res.json(returnCode.SUCCESS);
                }
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//H5创建子话题文章
router.post('/h5/thread/create', function(req, res, next) {
    var pid = req.body.pid;
    var title = req.body.title;
    var content = req.body.content;
    var images = req.body.images;
    var ent_code = req.body.ent_code;
    var nickName = req.body.nickName;
    var uid = req.body.openId;
    var mid = req.body.mid;

    var thread_entity = {
        pid : pid,
        title : title,
        content : content,
        ent_code: ent_code,
        images: images,
        type : 1,
        level : 2
    }

    if(pid && title && content && ent_code && uid && mid){
        async.waterfall([
            function(callback) {
                forumUserService.getUserByUid(uid, callback);
            },
            function(user, callback) { //创建用户
                if (user) {
                    callback(null, user);
                } else {
                    var entity = {
                        mid: mid,
                        uid: uid,
                        ent_code: ent_code,
                        nickName: nickName
                    };
                    forumUserService.createUser(entity, function(err, doc) {
                        if (err) {
                            console.error(err);
                            callback(err, null);
                        } else {
                            callback(null, doc);
                        }
                    });
                }
            },
            function(user, callback) {//获取板块信息
                forumThreadService.getByConditionsSelectyField({_id: new mongoose.Types.ObjectId(pid), ent_code: ent_code}, "info", function(err, doc) {
                    if (err || !doc) {
                        console.error(err);
                        callback(err, null, null);
                    } else {
                        callback(err, user, doc.info);
                    }
                });
            },
            function(user, infoId, callback) {//创建文章
                thread_entity.from = user._id;
                thread_entity.info = infoId
                forumThreadService.createThread(thread_entity, function(err, entity) {
                    if (err) {
                        console.error(err);
                        callback(err, null);
                    } else {
                        httpService.sendRequest(req.session.user.ent_code, req.session.openUser.mid, 'post');
                        forumAboutMEService.saveThread(entity);
                        callback(null, entity);
                    }
                });
            }
        ], function(err, thread) {
            if(err){
                res.json(returnCode.BUSY);
            }else{
                var rs = {
                    data:thread
                }
                res.json(_.assign(rs, returnCode.SUCCESS));
            }
        });
    }else{
        res.json(returnCode.WRONG_PARAM);
    }
});


//获取用户收藏的帖子,活动贴
router.get('/thread/getUserFavorThread/:type', function(req, res, next) {
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var type = req.params.type || null;
    var userId = user.getMobileUser(req);
    var ent_code = req.session.user.ent_code;
    var q = {
        ent_code: ent_code,
        from: userId
    };

    forumFollowThreadService.findAll(q, null, 'thread', function(err, doc){
        if(err || !doc){
            console.error(err);
            res.json(returnCode.BUSY);
        }else {
            var thread_ids = [];
            for(var i = doc.length - 1; i >= 0; i--){
                thread_ids.push(doc[i].thread);
            }

            var today = new Date();
            var conditions = {
                ent_code: ent_code,
                _id:{$in:thread_ids}
            };

            if(type == 1){
                conditions.isEvent = {
                    $ne:1
                }
            }else if(type == 2){
                conditions.isEvent = 1;
                conditions['event.eventStartTime'] = {$lte : today};
            }

            queryThread(conditions, pageNo, pageSize, '-created', function(err, results){
                if(err){
                    console.error(err);
                    res.json(returnCode.BUSY);
                }else{
                    util.loadLevel(ent_code, results.items, function() {
                        handleThreadList(req, results, ent_code, function(result){
                            res.json(_.assign(result, returnCode.SUCCESS));
                        });
                    });
                }
            });
        }
    });
});

//获取用户收藏的帖子的ID return  Map
router.get('/thread/getUserFavorAllThread', function(req, res, next) {
    var userId = user.getMobileUser(req);
    var ent_code = req.session.user.ent_code;
    var q = {
        ent_code: ent_code,
        from: userId
    };
    forumFollowThreadService.findAll(q, null, 'thread', function(err, results){
        if(err || !results){
            console.error(err);
            res.json(returnCode.BUSY);
        }else {
            var map = { //返回map对象，方便前端查找
                data:{}
            };
            _.forEach(results, function(d){
                map.data[d.thread] = 1;
            });
            res.json(_.assign(map, returnCode.SUCCESS));
        }
    });
});

//获取一级评论详情以及二级评论列表
router.get('/thread/comment/:cid/get', function(req, res, next) {
    var userId = user.getMobileUser(req);
    var ent_code = req.session.user.ent_code;
    var cid = req.params.cid;
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;

    var q = {
        ent_code: ent_code,
        _id:cid
    };
    forumCommentService.getCommentByIdWhitChirdentComment(q, pageNo, pageSize, function(err, result){
        if(err || !result){
            console.error(err);
            res.json(returnCode.BUSY);
        }else {
            var rs = {};
            rs.data = result;
            res.json(_.assign(rs, returnCode.SUCCESS));
        }
    });
});