'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//话题评论
var ForumAboutMeSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	from: {//该记录的作者
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumUser'
	},
	to: {//如果是评论， 代表被评论人
		type: Schema.Types.ObjectId,
		require: false,
		index: true,
		ref: 'ForumUser'
	},
	type:{//分类 1帖子 2一级评论 3二级评论 
		type: Number,
		index: true,
		require: true,
		default: 0
	},
	thread:{//帖子
		type: Schema.Types.ObjectId,
		index: true,
		ref: 'ForumThread',
		require:true
	}, 
	threadStatus:{  //0屏蔽 1.正常， 2删除
		type: Number
	},
	commentLevel1:{//一级评论
		type: Schema.Types.ObjectId, 
		require: false,
		index: true,
		ref: 'ForumComment'
	},
	commentLevel1From:{//一级评论的作者
		type: Schema.Types.ObjectId,
		require: false,
		index: true,
		ref: 'ForumUser'
	},
	commentLevel1Status:{ //0屏蔽 1.正常， 2删除
		type: Number
	},
	commentLevel2:{//二级评论
		type: Schema.Types.ObjectId,
		require: false,
		index: true,
		ref: 'ForumComment'
	},
	commentLevel2ThreadFrom:{//二级评论对应的帖子的发帖人
		type: Schema.Types.ObjectId,
		require: false,
		ref: 'ForumUser'
	},
	commentLevel2Status:{
		type: Number
	},
	created: { //时间
		type: Date,
		require: true,
		default: Date.now
	}
}, {
	'collection': 'pisns_forum_about_me'
});

module.exports = mongoose.model('ForumAboutMe', ForumAboutMeSchema);