'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//行为限制日志
var ForumLimitOperationLogSchema = new Schema({
	ent_code: {
        type: Number,
        require: true,
        index: true
    },
    userId: { //forumUser id
        type: String,
        index: true,
        require: true
    },
    mid: { //会员ID
        type: Number,
        require: true,
        index: false
    },
    limit_reason: { //原因
        type: String,
        default: ''
    },
    limit_type: {  //限制类型, 1 禁言, 2 不加积分
        type: String,
        default: ''
    },
    begin_time: { //开始时间
        type: Date
    },
    end_time: { //结束时间
        type: Date
    },
    days:{   //限制天数
        type: Number,
        require: false
    },
    created: {
        type: Date,
        required: true,
        default: Date.now
    }
}, {
	'collection': 'pisns_forum_limit_operation_log'
});

module.exports = mongoose.model('ForumLimitOperationLog', ForumLimitOperationLogSchema);