'use strict';

var mongoose = require('mongoose'),
    Schema = mongoose.Schema;
//版主申请
var ForumModeratorApplySchema = new Schema({
    ent_code: {
        type: Number,
        require: true,
        index: true
    },
    forumUser: {
        type: Schema.Types.ObjectId,
        require: true,
        index: true,
        ref: 'ForumUser'
    },
    applyMsg: { //申请信息
        type: String
    },
    applyTime: { //申请时间
        type: Date,
        require: true,
        default: Date.now
    },
    throughTime: { //通过时间
        type: Date,
        require: true
    },
    status: { //状态 1 通过 , 2 不通过
        type: Number,
        require: true,
        default: 2
    },
    infoIds: [ //板块ids
         {type: Schema.Types.ObjectId, ref: 'ForumInfo'}
    ],
    created: {
        type: Date,
        required: true,
        default: Date.now
    }
}, {
    'collection': 'pisns_forum_moderator_apply'
});


module.exports = mongoose.model('ForumModeratorApply', ForumModeratorApplySchema);
