'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//论坛角色权限
var ForumRolePermissionSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	role: {//角色
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumRole'
	},
	permission: {//权限
		type: Array
	},
	rules:{//角色匹配规则
		type: Array
	},
	status: { //权限1，可用，0禁用
		type: Number,
		require: true,
		default: 1
	},  
	created: {
	    type: Date,
	    required: true,
	    default:Date.now    
	}
}, {
	'collection': 'pisns_forum_role_permission'
});


module.exports = mongoose.model('ForumRolePermission', ForumRolePermissionSchema);