'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;
//话题，文章
var ForumThreadSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	info: {
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumInfo'
	},
	from: { //发帖者
		type: Schema.Types.ObjectId,
		require: true,
		index: true,
		ref: 'ForumUser'
	},
	title: { //话题标题
		type: String,
		require: true
	},
	type:{//文章类型 1、文章 2、话题 3、照片墙
		type: Number,
		require: true
	},
	level:{ //文章等级（1级在列表页显示 2级是归属于话题、照片墙的文章）
		type: Number,
		require: true,
		default:1
	},
	pid:{
		type: Schema.Types.ObjectId
	},
	content: { //话题内容
		type: String
	},
	icon: { //话题图标
		type: String
	},
	address: {//地址
      country:{type: String,default:''},
      province:{type: String,default:''},
      city:{type: String,default:''},     
    },
	order_idx: { //论坛排序
		type: Number,
		require: true,
		default: 0
	},
	top: { //话题是否置顶0否，1是
		type: Number,
		require: true,
		default: 0
	},
	topTime:{//置顶时间
		type: Date
	},
	top_order_idx:{
		type: Number,
		require: true,
		default: 0
	},
	tag_top: { //标签话题是否置顶0否，1是
		type: Number,
		require: true,
		default: 0
	},
	tag_topTime:{//标签话题置顶时间
		type: Date
	},
	tag:      [{type: Schema.Types.ObjectId, ref: 'ForumTag'}],//话题归属标签,
	comments: [{type: Schema.Types.ObjectId, ref: 'ForumComment'}], //评论内容列表
	images:   {//文章图片列表
		type : Array
	}, 
	share: { //自定义分享
		type: Schema.Types.ObjectId,
		ref: 'ForumShare'
	},
	share_type:{//是否使用默认设置:1使用默认分享设置  2.使用自己的分享设置
		type:Number,
		require:true,
		default:1
	},
	pv_count: { //话题的访问量
		type: Number,
		require: true,
		default: 0
	},
	comment_count: { //评论数量
		type: Number,
		require: true,
		default: 0
	},
	share_count: { //分享数量
		type: Number,
		require: true,
		default: 0
	},
	praise_count: { //点赞数量
		type: Number,
		require: true,
		default: 0
	},
	status: { //文章状态，1启用，0禁用，2需审核,3逻辑删除
		type: Number,
		require: true,
		default: 1
	}, 
	recommend:{//加精 0否 1是
		type: Number,
		require: true,
		default: 0
	}, 
	quality:{//质量 高：100，中：50，低：0
		type: Number,
		require: true,
		default: 100
	},
	new_recommend : { //推荐 0否，1是
		type: Number,
		require: true,
		default: 0
	},
	new_recommend_time:{//推荐时间
		type: Date
	},
	new_recommend_order_idx:{
		type: Number,
		require: true,
		default: 0
	},
	favor_by: [{ //被收藏用户列表 
	    type: Schema.Types.ObjectId,
	    ref: 'ForumUser'
	}],
	isEvent:{//是否活动改为0立即发布，1活动，2定时发布(到了发布时间才在手机端显示) by lws 20160317
		type: Number,
		require: true,
		default: 0
	}, 
	event: { //活动
		eventStartTime:{
			type: Date,
		    required: false
		},
		eventEndTime:{
			type: Date,
		    required: false
		}
	},
	release_time:{//发布时间，如果isEvent为2就是定时发布,需要发布时间
		type: Date,
		required: false
	},
	created: {
	    type: Date,
	    required: true,
	    default:Date.now    
	}
	,isPublishByBg:{
		type: Number,
		require: false,
		default: 0
	}
}, {
	'collection': 'pisns_forum_thread'
});

module.exports = mongoose.model('ForumThread', ForumThreadSchema);