'use strict';

var mongoose = require('mongoose'),
	Schema = mongoose.Schema;

//消息封装
var subMsgSchema = mongoose.Schema({
    msg : { //消息
        type: Schema.Types.ObjectId,
        ref: 'ForumMessage'
    },
    status: { //状态，0未读，1已读, 2用户屏蔽
		type: Number,
		require: true,
		default: 0
	}
},{ _id : true });

//论坛用户
var ForumUserSchema = new Schema({
	ent_code: {
		type: Number,
		require: true,
		index: true
	},
	uid: { //用户ID，这里直接存放用户的openId
		type: String,
		index: true,
		unique:true,
		require: true
	},
	mid: { //会员ID，这里直接存放会员ID
		type: Number,
		index: true,
		unique:true,
		require: false
	},
	nickName: { //用户昵称，这里直接存放用户的nickname
		type: String
	},
	displayName: { //自定义显示名称
		type: String
	},
	icon: { //用户头像
		type: String,
		require: true
	},
	displayIcon: { //自定义显示头像
		type: String
	},
	sex:{ //性别
		type: Number
	},
	classLevel: { //等级,暂时不用
		type: Number,
		require: true,
		default: 0
	},
	address: {//地址
      country:{type: String,default:''},
      province:{type: String,default:''},
      city:{type: String,default:''},     
    },
	status: { //用户状态1，正常，2黑名单
		type: Number,
		require: true,
		default: 1
	},  
	honorTitles: [{ //荣誉头衔数组
	    type: Schema.Types.ObjectId,
	    ref: 'ForumHonorTitle'
	}],
	favor_by: [{ //被收藏用户列表 
	    type: Schema.Types.ObjectId,
	    ref: 'ForumUser'
	}],
	favor_users: [{ //收藏用户列表
	    type: Schema.Types.ObjectId,
	    ref: 'ForumUser'
	}],
	favor_infos: [{ //收藏板块列表
	    type: Schema.Types.ObjectId,
	    ref: 'ForumInfo'
	}],
	favor_threads: [{ //收藏文章列表
	    type: Schema.Types.ObjectId,
	    ref: 'ForumThread'
	}],
  	messages: [subMsgSchema],
	created: {
	    type: Date,
	    required: true,
	    default:Date.now    
	}
}, {
	'collection': 'pisns_forum_user'
});


module.exports = mongoose.model('ForumUser', ForumUserSchema);