'use strict';
var mongoose = require('mongoose');
var ForumLimitActionRef = mongoose.model('ForumLimitActionRef');

var async = require('async');
var then = require('thenjs');
var moment = require('moment');

//格式化日期 (格式：年-月-日)
function date_format(date) {
    return moment(date).format('YYYY-MM-DD');
}

//判断时间是否在指定范围
function compareTime(now, begin_time, end_time) { // 禁言中 true
    now = date_format(now);
    begin_time = date_format(begin_time);
    end_time = date_format(end_time);
    if (moment(now).isSame(begin_time) || moment(now).isSame(end_time)) { //如果等于开始时间或者结束时间
        return true;
    } else {
        return moment(now).isBetween(begin_time, end_time);
    }
}

//获取数量
function countAll(conditions,callback) {
	ForumLimitActionRef.count(conditions, function (err, count) {
	   if(err){
	   		console.error(err);
			callback(err,null);
	   }else{
	   		callback(null,count);
	   }
	});
}

//获取单个行为限制
function getLimitActionRef(userId,callback){
	ForumLimitActionRef.findOne({userId:userId}, function(err, role) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,role);
		}
	});
}



//创建或更新论坛行为限制
exports.createOrUpdateLimitActionRef=function(conditions,entity,callback){
	ForumLimitActionRef.findOneAndUpdate(conditions, {
        limit_actions: entity.limit_actions
    }, function(err, doc) {
        if (err) {
        	console.log(err);
            callback(err, null);
        } else {
            if(!doc){
            	var forum = new ForumLimitActionRef(entity);
				forum.save(function(err, forum) {
					if (err) {
						console.error(err);
						callback(err,null);
					} else {
						callback(null,forum);
					}
				});
            }else{
            	callback(null,doc);
            }
        }
    });
};


//创建论坛行为限制
exports.createLimitActionRef=function(entity,callback){
	var forum = new ForumLimitActionRef(entity);
	forum.save(function(err, forum) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,forum);
		}
	});
};

//根据MID和EntCode获取
exports.getLimitActionRefByMIdAndEntCode=function(userId,ent_code,callback){
	ForumLimitActionRef.findOne({userId:userId,ent_code:ent_code}, function(err, role) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,role);
		}
	});
};

//根据MID获取
exports.getLimitActionRefByMid=function(userId,callback){
	getLimitActionRef(userId, function(err, role) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,role);
		}
	});
};

//根据ID获取
// exports.getLimitActionRefById=function(rid,callback){
// 	ForumLimitActionRef.findById(rid, function(err, role) {
// 		if (err) {
// 			console.error(err);
// 			callback(err,null);
// 		} else {
// 			callback(null,role);
// 		}
// 	});
// };


//根据ID删除
// exports.deleteLimitActionRefById=function(rid,callback){
// 	ForumLimitActionRef.remove({ _id: rid},function(err,result){
// 		if (err) {
// 			console.error(err);
// 			callback(err,null);
// 		} else {
// 			callback(null,null);
// 		}
// 	});
// };



//获取全部列表数据
exports.getAllLimitActionRef= function(conditions,callback) {
	countAll(conditions,function(err,count){
		if(err){
			console.error(err);
			callback(err,null);
		}else{
		    ForumLimitActionRef.find(conditions).exec(function(err, docs) {
		    	if (err) {
					console.error(err);
					callback(err,null);
				} else {
					var obj={};
					obj.items=docs;
					callback(null,obj);
				}
		    });
		}
	});
};




//检查用户是否被禁言
exports.checkLimitActionProhibitionOfSpeech = function(userId,callback) {
	if(userId){
		var isProhibition = false;
		getLimitActionRef(userId,function(err,forumLimitActionRef){
			if (err) {
				console.error(err);
				callback(err, null);
			} else {
				// 获取到用户行为限制记录
				if(forumLimitActionRef){
					var limit_actions = forumLimitActionRef.limit_actions;
	                for (var i = 0; i < limit_actions.length; i += 1) {
	                    var limit_action = limit_actions[i];
	                    if(limit_action.limit_action_type == 'forum_prohibition_of_speech'){
	                    	if(limit_action.begin_time && limit_action.end_time){
	                    		var begin_time = new Date(limit_action.begin_time).getTime(),
	                    			ent_time = new Date(limit_action.end_time).getTime(),
	                    			now = new Date().getTime();
	                    		if(now >= begin_time && now <=ent_time){
	                    			isProhibition = true;
	                    			break;
	                    		}
	                    	}
	                    }
	                }
	                callback(null, isProhibition);
				}else{
					callback(null, isProhibition);
				}
			}
		});
	}else{
		callback(null, isProhibition);
	}
};


//检查用户是否被禁加积分
exports.checkLimitActionProhibitionAddIntegral = function(userId,callback) {
	var isProhibition = false;
	if(userId){
		getLimitActionRef(userId,function(err,forumLimitActionRef){
			if (err) {
				console.error(err);
				callback(err, null);
			} else {
				// 获取到用户行为限制记录
				if(forumLimitActionRef){
					var limit_actions = forumLimitActionRef.limit_actions;
	                for (var i = 0; i < limit_actions.length; i += 1) {
	                    var limit_action = limit_actions[i];
	                    if(limit_action.limit_action_type == 'forum_not_add_integral'){
	                    	if(limit_action.begin_time && limit_action.end_time){
	                    		var begin_time = new Date(limit_action.begin_time).getTime(),
	                    			ent_time = new Date(limit_action.end_time).getTime(),
	                    			now = new Date().getTime();
	                    		if(now >= begin_time && now <=ent_time){
	                    			isProhibition = true;
	                    			break;
	                    		}
	                    	}
	                    }
	                }
	                callback(null, isProhibition);
				}else{
					callback(null, isProhibition);
				}
			}
		});
	}else{
		callback(null, isProhibition);
	}
};