'use strict';
var mongoose = require('mongoose');
var Suggestion = mongoose.model('ForumSuggestion');

//创建
exports.create=function(entity,callback){
	var forum = new Suggestion(entity);
	forum.save(function(err, doc) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,doc);
		}
	});
};

//根据ID获取
exports.getById=function(id,callback){
	Suggestion.findById(id, function(err, doc) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,doc);
		}
	});
};

//根据条件更新
// exports.update=function(condition,entity,callback){
// 	Suggestion.update(condition, entity,null,function(err,result){
// 		if (err) {
// 			console.error(err);
// 			callback(err,null);
// 		} else {
// 			callback(null,null);
// 		}
// 	});
// };

//根据ID删除
exports.deleteById=function(tid,callback){
	Suggestion.remove({ _id: tid},function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//更新
exports.findOneAndUpdate=function(condition,entity,callback){
	Suggestion.findOneAndUpdate(condition, entity,null,function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,result);
		}
	});
};

//获取数量
function countAll(conditions,callback) {
	Suggestion.count(conditions, function (err, count) {
	   if(err){
	   		console.error(err);
			callback(err,null);
	   }else{
	   		callback(null,count);
	   }
	});
}

//分页查询
exports.getAll= function(conditions,pageNo,pageSize,callback) {
	countAll(conditions,function(err,count){
		if(err){
			console.error(err);
			callback(err,null);
		}else{
			var skip = (pageNo - 1) * pageSize;
		    var limit = count - skip > pageSize ? pageSize : (count - skip);
			Suggestion.find(conditions).populate({
	            path: 'from',
	            select: 'mid nickName icon'
	        }).skip(skip).limit(limit).sort({created:-1}).exec(function(err, docs) {
				if (err) {
					console.error(err);
					callback(err,null);
				} else {
					var obj={};
					obj.total=count;
					obj.pageNo=pageNo;
					obj.pageSize=pageSize;
					obj.items=docs;
					callback(null,obj);
				}
			});
		}
	});
};