'use strict';
var mongoose = require('mongoose');
var ForumUserHonorTimeLine = mongoose.model('ForumUserHonorTimeLine');

//创建
exports.create = function(entity, callback) {
    var forum = new ForumUserHonorTimeLine(entity);
    forum.save(function(err, doc) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, doc);
        }
    });
};

//根据ID获取
exports.getById = function(tid, callback) {
    ForumUserHonorTimeLine.findById(tid, function(err, doc) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, doc);
        }
    });
};

//根据ID更新
exports.updateById = function(tid, entity, callback) {
    ForumUserHonorTimeLine.update({
        _id: tid
    }, entity, null, function(err, result) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, null);
        }
    });
};

//根据ID删除
exports.deleteById = function(tid, callback) {
    ForumUserHonorTimeLine.remove({
        _id: tid
    }, function(err, result) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, null);
        }
    });
};

//根据条件删除
exports.deleteByCondition = function(condition, callback) {
    ForumUserHonorTimeLine.remove(condition, function(err, result) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, null);
        }
    });
};

//获取数量
function countAll(conditions, callback) {
    ForumUserHonorTimeLine.count(conditions, function(err, count) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, count);
        }
    });
}

//分页查询
exports.getAll = function(pageNo, pageSize, conditions, fields, sort, callback) {
    countAll(conditions,function(err,count){
        if(err){
            console.error(err);
            callback(err,null);
        }else{
            var skip = (pageNo - 1) * pageSize;
            var limit = count - skip > pageSize ? pageSize : (count - skip);

            ForumUserHonorTimeLine.find(conditions).skip(skip).limit(limit).sort(sort).populate({
                path: 'user',
                select: fields
            }).exec(function(err, docs) {
                var obj={};
                obj.total=count;
                obj.pageNo=pageNo;
                obj.pageSize=pageSize;
                obj.datas=docs;
                callback(null,obj);
            });
        }
    });
};




