'use strict';

var caches = {//缓存集合

};
var CacheNode = function(content,expire){//定义缓存对象
	this.content = content;
	this.expire = expire || (3600 * 1000);
	this.created = new Date().getTime();
};
CacheNode.prototype.expireIf = function(){//定义缓存对象的静态方法，判断缓存是否过期
	return new Date().getTime() - this.created > this.expire;
};
function getKey(key){
	return 'forum_simple_cache_'+key;
}
function get(key){
	var cache = caches[getKey(key)];
	if(cache && !cache.expireIf()){
		return cache.content;
	}
	return null;
}
function getIfAbsentDO(key,operate,expire,callback){//不过不存在就调用opreate的回调的参数为err,result 并把结果放入cache，然后调用callback 返回结果
	var content = get(key);
	if(content){
		return callback && callback(null,content);
	}
	if(operate){
		operate(function(err,result){
			if(!err){//放入缓存
				put(key,result,expire);
			}
			callback(err,result);
		});
	}else{
		return callback && callback(null,null);
	}
}
function put(key,val,expire){
	var cache = new CacheNode(val,expire);
	caches[getKey(key)] = cache;
	return true;
}
function putIfAbsent(key,val,expire){
	var cache = get(key);
	if(!cache || cache.expireIf()){//不存在或者过期
		return put(key,val,expire);
	}
	return false;
}
function clear(){
	caches = {};
}
function remove(key){
	delete caches[getKey(key)];
}

exports.put = put;
exports.putIfAbsent = putIfAbsent;
exports.get = get;
exports.getIfAbsent = getIfAbsentDO;
exports.remove = remove;
exports.clear = clear;

/*getIfAbsentDO('test',function(callback){
	callback(false,{11111111111:1111111111111});
},333,function(err,result){
	setTimeout(function(){
		console.log(caches);
		console.log(get('test'));;
	},11);
});*/
