'use strict';
var async = require('async');
var mongoose = require('mongoose');
var Grid = require('gridfs-stream');
var fse = require("fs-extra");
var fs = require('fs');
var crypto = require('crypto');
var ossClient = require('oss-easy');
var env = require('../../config/config');
var JAVA_UPLOADFILE_API=env.rest_api + '/v1.0/internal/common/imageUpload';
var request = require('request');
var ossOption = {
    accessKeyId: env.ossConfig.accessKeyId,
    accessKeySecret: env.ossConfig.accessKeySecret
};

var nodeEnv = (process.env.NODE_ENV || 'development')
var isDebug = nodeEnv === 'development' || nodeEnv === 'sandbox' ? true: false;

var bucketName = isDebug === true ? env.ossConfig.bucketNameDev : env.ossConfig.bucketNameProd;
var ofs = new ossClient(ossOption, bucketName);

var gfs = null;

function handleUpload(req, uploadfile, storageType, targetPath, callback) {
    if (!uploadfile) return;
    var current = new Date();
    var md5 = crypto.createHash('md5');
    var filename = targetPath + current.getFullYear() + (current.getMonth() + 1) + current.getDate();
    filename += '/';
    var pos = uploadfile.name.lastIndexOf('.');
    var suffix = '';
    if (pos > 0) {
        suffix = uploadfile.name.substr(pos);
    }

    md5.update(current.getTime() + '_' + uploadfile.name);
    filename += md5.digest('hex') + suffix;
    if (storageType === 'local') {
        var fileSavePath = process.cwd() + targetPath + "/" + filename;
        fse.move(uploadfile.path, fileSavePath, function(err) {
            if (err) throw callback(err, null);
            callback(null, {
                originalName: uploadfile.name,
                fileName: filename,
                fileType: uploadfile.type,
                fileSize: uploadfile.size,
                urlFileName: global.getDFSUrlRoot() + filename,
                fieldName: uploadfile.fieldName
            });

        });
    } else if (storageType === 'gfs') {
        if (!gfs) {
            gfs = Grid(mongoose.connection.db, mongoose.mongo);
        }
        var gfs_options = {
            filename: filename,
            mode: 'w',
            content_type: uploadfile.type,
            metadata: {
                'originalName': uploadfile.name
            }
        };
        var writestream = gfs.createWriteStream(gfs_options);
        fs.createReadStream(uploadfile.path).pipe(writestream);
        writestream.on('error', function(err) {
            console.log(err);
            callback(err, null);
        });
        writestream.on('close', function(file) {
            fs.unlink(uploadfile.path, function(err) {
                if (err) {
                    console.log(err);
                }
            });
            callback(null, {
                originalName: uploadfile.name,
                fileName: filename,
                fileType: uploadfile.type,
                fileSize: uploadfile.size,
                urlFileName: global.getDFSUrlRoot() + filename,
                fieldName: uploadfile.fieldName
            });
        });

    } else if (storageType === 'oss') {
        var filePath = '';
        if (req.session.user.ent_code) {
            filePath += req.session.user.ent_code + '_';
        }
        filePath += '' + current.getFullYear() + (current.getMonth() + 1) + current.getDate();
        filePath += '_' + current.getTime() + '_' + Math.round(Math.random() * 100) + suffix;
        var metadata = {
            'Content-Disposition': 'attachment;filename=' + filePath,
            'Cache-Control': 'max-age=86400'
        };
        filePath = 'upload/' + filePath;
        var url = isDebug === true ? env.ossConfig.devCDNURL : env.ossConfig.prodCDNURL;
        ofs.uploadFile(uploadfile.path, filePath, metadata, function(err) {
            if (err) {
                console.log(err);
                callback(err, null);
            } else {
                callback(null, {
                    originalName: uploadfile.name,
                    fileName: filePath,
                    fileType: uploadfile.type,
                    fileSize: uploadfile.size,
                    urlFileName: url + filePath,
                    fieldName: uploadfile.fieldName
                });
            }
        });
    }
}

function handleUploadWithJavaAPI(uploadfile, callback) {
    if (!uploadfile) return callback && callback(null,null);
    var req = request.post({
        url: JAVA_UPLOADFILE_API,
        json: true
    }, function (err, resp, body) {
        if (err) {
            callback(err, null);
        }else if(!body || !body.data || !body.data.url){
            console.log(body);
            callback('返回数据错误', null);
        } else {
            callback(null, {
                originalName: body.data.fileName,
                fileName: body.data.url,
                fileType: uploadfile.type,
                fileSize: uploadfile.size,
                urlFileName: body.data.url,
                fieldName: uploadfile.fieldName
            });
        }
    });
    var form = req.form();
    form.append('file', fs.createReadStream(uploadfile.path));
}

module.exports = function(storageType, targetPath) {
    return function(req, res, next) {
        var storePath = targetPath || '/default/';
        if (req.session.user.ent_code) storePath += req.session.user.ent_code + '/';
        var files = req.files;
        var items = [];
        for (var key in files) {
            if (files[key] instanceof Array) {
                items = items.concat(files[key]);
            } else {
                items.push(files[key]);
            }
        }
        var asyncTasks = [];
        items.forEach(function(file) {
            asyncTasks.push(function(callback) {
                //handleUpload(req, file, storageType, storePath, callback);
                handleUploadWithJavaAPI(file, callback);
            });
        });

        async.parallel(asyncTasks, function(err, results) {
            if (err) {
                console.log(err);
            } else {
                req.uploadFile = results;
            }
            next(null);
        });
    }
}