'use strict';

var _ = require('lodash');
var request = require('request');
var env = process.env.NODE_ENV;
var API_ADDRESS = 'http://localhost:8082';
if (env == 'sandbox') {
    API_ADDRESS = 'http://rest.wxpai.cn';
} else if (env == 'production') {
    API_ADDRESS = 'https://rest.wxpai.cn';
}


var forumUserService=require('../service/forumUserService');

exports.getMobileUser=function(req){
	return req.session.mobileForumUser.userId;
}

exports.getOpenId=function(req){
	return req.session.mobileForumUser.openId;
}

exports.identifyUser=function() {

	return function(req, res,next){
		if(!req.session.mobileForumUser){
			if(req.session.openUser){
				forumUserService.getUserByUid(req.session.openUser.openId,function(err,doc){
					if(err){
						next(err);
					}else{
						if(doc){
							req.session.mobileForumUser={
								userId:doc._id,
								openId:doc.uid,
								mid:doc.mid
							};
							if(req.session.source){
								if(req.session.source !== req.session.mobileForumUser.userId){
									req.session.mobileForumUser.source = req.session.source;
									delete req.session.source;		
								}
							}
							next(null);
						}else{
							if(req.session.tmpOpenId){
								next(null);
							}else{
								req.session.tmpOpenId=req.session.openUser.openId;
								var entity={
									uid:req.session.openUser.openId,
									nickName:req.session.openUser.nickName,
									icon:req.session.openUser.headPic,
									ent_code:req.session.user.ent_code,
									mid:req.session.openUser.mid
								};
								forumUserService.createUser(entity,function(err,doc){
									if(err){
										next(null);
									}else{
										req.session.mobileForumUser={
											userId:doc._id,
											openId:doc.uid,
											mid:doc.mid
										};
										if(req.session.source){
											if(req.session.source !== req.session.mobileForumUser.userId){
												req.session.mobileForumUser.source = req.session.source;
												delete req.session.source;		
											}
										}

										next(null);
									}
								});
							}
						}
					}
				});
			}else{
				next('no openUser in session');
			}
		}else{
			if(req.session.source){
				if(req.session.source !== req.session.mobileForumUser.userId){
					req.session.mobileForumUser.source = req.session.source;
					delete req.session.source;		
				}
			}
			next(null);
		}
		
	}

}

exports.findMember=function(ent_code, mid, callback){
	var url = API_ADDRESS + '/v1.0/internal/member/infoAndRankInfo';
    request.post({
        url: url,
        json: {
            entCode:ent_code,
            ids:[mid]
        }
    }, function(e, r, body) {
        if (e) {
            console.log(e)
            callback(e, null);
        }else{
            callback(null, body.data);
        }
    });
}



exports.getMemberExp=function(ent_code,mid,type,callback){
    if(!ent_code || !mid){
        return callback && callback(null,null);
    }
    var url = API_ADDRESS + '/v1.0/internal/member/exp/getMemberInfo?mid='+mid+'&entCode='+ent_code+'&type='+type;
    request.get({
        url: url,
        json: {}
    }, function(e, r, body) {
        if (e) {
            console.log(e)
        }
        return callback && callback(null,(body && body.data) || null);
    });
};

exports.getMemberExpTopChart=function(ent_code,callback){
    if(!ent_code){
        return callback && callback(null,null);
    }
    var url = API_ADDRESS + '/v1.0/internal/member/exp/all?entCode='+ent_code;
    request.get({
        url: url,
        json: {}
    }, function(e, r, body) {
        if (e) {
            console.log(e)
        }
        return callback && callback(null,(body && body.data) || null);
    });
};

exports.getMemberExpTopMonthChart=function(ent_code,callback){
    if(!ent_code){
        return callback && callback(null,null);
    }
    var url = API_ADDRESS + '/v1.0/internal/member/exp/month?entCode='+ent_code;
    request.get({
        url: url,
        json: {}
    }, function(e, r, body) {
        if (e) {
            console.log(e)
        }
        return callback && callback(null,(body && body.data) || null);
    });
};

exports.getMemberExpTopWeekChart=function(ent_code,callback){
    if(!ent_code){
        return callback && callback(null,null);
    }
    var url = API_ADDRESS + '/v1.0/internal/member/exp/week?entCode='+ent_code;
    request.get({
        url: url,
        json: {}
    }, function(e, r, body) {
        if (e) {
            console.log(e)
        }
        return callback && callback(null,(body && body.data) || null);
    });
};