'use strict';

var CUSTOMERSERVICE_API="http://localhost:8080";

var websocketApp = angular.module('websocketApp',['ngCookies', 'ngResource',  'ui.router']);
websocketApp.config(['$stateProvider',
    function($stateProvider) {
        var states = [];
        angular.forEach(states, function(item) {
            $stateProvider.state(item);
        });
    }
]);

websocketApp.service('WebSocketService', 
		['$q', '$rootScope','$resource', function($q, $rootScope,$resource) {
    var Service = {};
    var callbacks = {};
    var currentCallbackId = 0;
    var ws = new WebSocket("ws://localhost:8080/im");
    var curUser = {};

    ws.onopen = function(){  
        console.log("连接到了服务器!");
        $resource(CUSTOMERSERVICE_API + '/customerservice/signed')
        .get({},function(res){
        	curUser = res && res.data;
        },function(res){
        	console.log('获取用户信息失败');
        });
    };
    
    ws.onclose = function () {
    	console.log('连接被关闭.');
	};
	
    ws.onmessage = function(message) {
        listener(JSON.parse(message.data));
    };

    function sendRequest(request) {
      var defer = $q.defer();
      var callbackId = getCallbackId();
      callbacks[callbackId] = {
        time: new Date(),
        cb:defer
      };
      request.callbackId = callbackId;
      ws.send(JSON.stringify(request));
      return defer.promise;
    }

    function listener(data) {
      var messageObj = data;
      if(callbacks.hasOwnProperty(messageObj.callbackId)) {//主动请求
        $rootScope.$apply(callbacks[messageObj.callbackId].cb.resolve(messageObj));
        delete callbacks[messageObj.callbackId];
      }else{//服务端推送（广播给子scope）
    	  $rootScope.$broadcast(messageObj.msgType, messageObj);
      }
    }
    
    function getCallbackId() {
      currentCallbackId += 1;
      if(currentCallbackId > 10000) {
        currentCallbackId = 0;
      }
      return currentCallbackId;
    }

    Service.sendMessage = function(message){
	  var request = {
        message:message
	  }
	  var promise = sendRequest(request); 
	  return promise;
    };
    Service.getCurUser = function(){
    	return curUser;
    }
    return Service;
}]);

websocketApp.controller('UserListCtrl', 
		['$scope', '$rootScope', '$location', '$resource', '$stateParams','WebSocketService',
        function($scope, $rootScope, $location, $resource, $stateParams,WebSocketService) {
		$scope.users = [];//[{nickName:'111111',messages:11}];
		$scope.$on('newUser', function(event,data) {
			$scope.$apply(function(){
				$scope.users.push(data.data.openId);
			});
		}); 
}]);

websocketApp.controller('MessagesCtrl', 
		['$scope', '$rootScope', '$location', '$resource', '$stateParams','$sce','WebSocketService',
        function($scope, $rootScope, $location, $resource, $stateParams,$sce,WebSocketService) {
		$scope.message = "";
		var messages = $scope.messages = [];
		var openId = '';
		var tplMessage={
			    touser:'ogoz1t65VSnKQQvYrD9-SLBL2KIk',
			    msgtype:'text',
			    text:
			    {
			         content:''
			    }
		};
		
		var news={
			    touser:'ogoz1t65VSnKQQvYrD9-SLBL2KIk',
			    msgtype:'news',
			    news:{
			        articles: [
			         {
			             title:'Happy Day',
			             description:'Is Really A Happy Day',
			             url:'https://ss1.baidu.com/9vo3dSag_xI4khGko9WTAnF6hhy/super/whfpf%3D425%2C260%2C50/sign=a5c6f9f036fa828bd176cea39b227506/faf2b2119313b07ed3782dfd09d7912396dd8c79.jpg',
			             picurl:'https://ss1.baidu.com/9vo3dSag_xI4khGko9WTAnF6hhy/super/whfpf%3D425%2C260%2C50/sign=a5c6f9f036fa828bd176cea39b227506/faf2b2119313b07ed3782dfd09d7912396dd8c79.jpg'
			         }]
			    }
			};
		$scope.$on('text', function(event,data) {
			$scope.$apply(function(){
				var m = {type:1,message:''};
				m.message = $sce.trustAsHtml(data.content);
				$resource('http://sandbox.wxpai.cn/open/user/info?appId=wx3e055e220ddde820&openId='+data.openId)
				.get({},function(res){
					console.log(res);
					m.headimgurl=res.data.headimgurl;
					m.openid=res.data.openid;
				},function(res){
					
				});
				messages.push(m);
			});
		}); 
		
		$scope.$on('image', function(event,data) {
			$scope.$apply(function(){
				if(data.mediaId){
					var m = {type:1,message:''};
					var picUrl = 'http://sandbox.wxpai.cn/open/media/get?appId=wx3e055e220ddde820&mediaId='+data.mediaId;
					m.message = $sce.trustAsHtml('<img src=\"'+picUrl+'" style="height:50px;width:50px;"/>');
					messages.push(m);
				}
			});
		});
		
		function pv_q(u, w, h){    
			var pv='';    
			pv += '<object data="'+u+'" width="'+w+'" height="'+h+'" classid="clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B" codebase="http://www.apple.com/qtactivex/qtplugin.cab">';    
			pv += '<param name="src" value="'+u+'">';    
			pv += '<param name="controller" value="true">';    
			pv += '<param name="type" value="video/quicktime">';    
			pv += '<param name="autoplay" value="true">';    
			pv += '<param name="target" value="myself">';    
			pv += '<param name="bgcolor" value="black">';    
			pv += '<param name="pluginspage" value="http://www.apple.com/quicktime/download/index.html">';    
			pv += '<embed src="'+u+'" width="'+w+'" height="'+h+'" controller="true" align="middle" bgcolor="black" target="myself" type="video/quicktime" pluginspage="http://www.apple.com/quicktime/download/index.html"></embed>';    
			pv += '</object>';    
			return pv;
		}
		$scope.$on('voice', function(event,data) {
			$scope.$apply(function(){
				if(data.mediaId){
					var m = {type:1,message:''};
					var voiceUrl = 'http://sandbox.wxpai.cn/open/media/get?appId=wx3e055e220ddde820&mediaId='+data.mediaId;
					/*m.message = $sce.trustAsHtml('<audio controls="controls" src=\"'+voiceUrl+'" style="height:50px;width:50px;"/>');*/
					m.message = $sce.trustAsHtml(pv_q(voiceUrl,'150px','50px'));
					messages.push(m);
				}
			});
		});
		
		$scope.$on('video', function(event,data) {
			$scope.$apply(function(){
				if(data.mediaId){
					var m = {type:1,message:''};
					var videoUrl = 'http://sandbox.wxpai.cn/open/media/get?appId=wx3e055e220ddde820&mediaId='+data.mediaId;
					m.message = $sce.trustAsHtml('<video controls="controls" src=\"'+voiceUrl+'" width="100px;" heiht="100px"/>');
					messages.push(m);
				}
			});
		});
		
		$scope.$on('shortvideo', function(event,data) {
			$scope.$apply(function(){
				if(data.mediaId){
					var m = {type:1,message:''};
					var shortvideoUrl = 'http://sandbox.wxpai.cn/open/media/get?appId=wx3e055e220ddde820&mediaId='+data.mediaId;
					m.message = $sce.trustAsHtml('<video controls="controls" src=\"'+shortvideoUrl+'" width="100px;" heiht="100px"/>');
					messages.push(m);
				}
			});
		});
		$scope.send= function(){
			if($scope.message){
				var m = {type:2,message:''};
				m.message = $sce.trustAsHtml($scope.message);
				m.headimgurl=WebSocketService.getCurUser().headImg;
				messages.push(m);
				/*WebSocketService.sendMessage($scope.message).then(function(res) {
					messages.push({type:1,message:res.message});
				}, function(res) {
					console.log(res);
				});*/
				tplMessage.text.content=$scope.message;
				$resource('http://sandbox.wxpai.cn/open/custom_send?appId=wx3e055e220ddde820')
				.save(news,function(res){
					console.log(res);
				},function(res){
					console.log(res);		
						});
				$scope.message = "";
			}
		}
}]);